--[[
file: test.lua
Author: Scott Loyd

This is a test run of everything.
]]--

GAMEMODE_ROUNDBASED = 1 --This is round based!
GAMEMODE_TEAMPLAY = 2 --Means it can be toggled

--Just test to see if everything gets called.
test = { }
test.eOnThink = false
test.ePlayerConnect = false
test.ePlayerDisconnect = false
test.ePreRoundBegin = false
test.ePostRoundBegin = false
test.ePrePlayerSpawn = false
test.ePostPlayerSpawn = false
test.eOnPlayerKilled = false
test.bCanPlayerRespawn = false

--Special function, only used in debug mode (called from ::Shutdown())
function fCheckTests()
	ConMsg "Test Results: \n"
	if(not test.eOnThink) then
		ConMsg " Failed Test: eOnThink\n"
	end
	if(not test.ePlayerConnect) then
		ConMsg " Failed Test: ePlayerConnect\n"
	end
	if(not test.ePlayerDisconnect) then
		ConMsg " Failed Test: ePlayerDisconnect\n"
	end
	if(not test.ePreRoundBegin) then
		ConMsg " Failed Test: ePreRoundBegin\n"
	end
	if(not test.ePostRoundBegin) then
		ConMsg " Failed Test: ePostRoundBegin\n"
	end
	if(not test.ePrePlayerSpawn) then
		ConMsg " Failed Test: ePrePlayerSpawn\n"
	end
	if(not test.ePostPlayerSpawn) then
		ConMsg " Failed Test: ePostPlayerSpawn\n"
	end
	if(not test.eOnPlayerKilled) then
		ConMsg " Failed Test: eOnPlayerKilled\n"
	end
	if(not test.bCanPlayerRespawn) then
		ConMsg " Failed Test: bCanPlayerRespawn\n"
	end
end

function GetGameDescription()
	return "GES-TEST";
end

function eOnThink()
	test.eOnThink = true
end

function ePlayerConnect(plyr)
	test.ePlayerConnect = true
end

function ePlayerDisconnect(plyr)
	test.ePlayerDisconnect = true
end

function ePreRoundBegin()
	test.ePreRoundBegin = true
end

function ePostRoundBegin()
	test.ePostRoundBegin = true
end

function ePrePlayerSpawn(plyr)
	test.ePrePlayerSpawn = true
end

function ePostPlayerSpawn(plyr)
	test.ePostPlayerSpawn = true
end

function eOnPlayerKilled(plyr,killer)
	ConMsg "eOnPlayerKilled"
end

function bCanPlayerRespawn(plyr)
	ConMsg "bCanPlayerRespawn"
	return true;
end