--[[
File: yolt.lua
Created On: 8/27/2006 7:40:01 PM
Created By: Scott Loyd <scottloyd@gmail.com>

For some odd reason, you only live twice...
]]--


g_iDeathCount = { }
g_bFirstKill = false;

function GetGameDescription()
	return "GES-YOLT";
end

function PreRoundBegin()
	g_bFirstKill = false
	for i=1,64 do
		g_iDeathCount[i]=0
	end
end

function OnPlayerKilled(victim,killer)
	g_iDeathCount[victim] = g_iDeathCount[victim] + 1;
	
	if(not g_bFirstKill) then
		-- Disallow late joins by setting max deaths to all players not playing.
		for i=1, 64 do
			if(not IsValidPlayer(i) or (PlayerTeam(i) <= TEAM_SPECTATOR)) then
				g_iDeathCount[i] = 2;
			end
		end
		g_bFirstKill = true
	end
	
	--Check to see if the round is over!
	if(IsTeamplay()) then
		-- check to see if each team has a player...
		local iMI6PlayersLeft = 0;
		local iJanusPlayersLeft = 0;
		for i=1,64 do
			if(g_iDeathCount[i] < 2) then
				if(PlayerTeam(i) == TEAM_MI6) then
					iMI6PlayersLeft = iMI6PlayersLeft + 1;
				elseif(PlayerTeam(i) == TEAM_JANUS) then
					iJanusPlayersLeft = iJanusPlayersLeft + 1;
				end
			end
		end
		if((iMI6PlayersLeft < 1) and (iJanusPlayersLeft < 1)) then
			ClientPrintAll(HUD_PRINTCENTER,"#TIE")
			EndRound()
		elseif(iMI6PlayersLeft < 1) then
			ClientPrintAll(HUD_PRINTCENTER,"#JANUS_WINS")
			EndRound()
		elseif(iJanusPlayersLeft < 1) then
			ClientPrintAll(HUD_PRINTCENTER,"#MI6_WINS")
			EndRound()
		end
	else
		--Check to see if more than one player is around
		local iPlayersLeft = 0;
		local iPlayerIndex = 0;
		for i=1,64 do
			if(g_iDeathCount[i] < 2) then
				iPlayerIndex = i;
				iPlayersLeft = iPlayersLeft + 1;
			end
		end
		if(iPlayersLeft <= 1) then
			ClientPrintAll(HUD_PRINTCENTER,"#PLAYER_WINS",PlayerName(iPlayerIndex))
			EndRound()
		end
	end
end

function CanPlayerRespawn(plyr)
	if(g_iDeathCount[plyr] >= 2) then
		return false;
	end
	return true;
end