--[[
file: dmnoarmor.lua
Author: Killer Monkey

Bring it on! (without armor)
]]--

--Callbacks

function OnLoadGamePlay()
 
	CreateCVar("dm_fraglimit", "0", "Enable frag limit for DeathMatch.");
	LoadConfig();	

end

function GetGameDescription()
	if ( IsTeamplay() ) then
		return "Team DM w/o Armor";
	else
		return "DM w/o Armor";
	end
end

function PreRoundBegin()
	SetAllowTeamSpawns( false );
	DisableArmorSpawns();
	ResetAllPlayersScores();
end

function PlayerKilled( victim, killer )
	if ( victim == killer ) then
		AddToPlayerScore( killer, -1 );
	elseif ( IsTeamplay() and GetPlayerTeam(killer) == GetPlayerTeam(victim) ) then
		AddToPlayerScore( killer, -1 );
	else
		-- In DM we add TEAM and PLAYER scores on a kill
		-- We don't care if teamplay is enabled, if its not this will be ignored
		AddToTeamScore( GetPlayerTeam(killer), 1 );
		AddToPlayerScore( killer, 1 );
	end
end


function Think()

	local fragLimit = tonumber(GetCVar("dm_fraglimit"));

	if (fragLimit ~= 0) then

		if (IsTeamplay()) then

			local jScore = GetTeamMatchScore(TEAM_JANUS) + GetTeamScore(TEAM_JANUS);
			local mScore = GetTeamMatchScore(TEAM_MI6) + GetTeamScore(TEAM_MI6);

			if (jScore >= fragLimit or mScore >= fragLimit) then
				EndMatch();
			end

		else
			for i=1,32 do
				if (IsValidPlayer(i) and (GetPlayerMatchScore(i)+GetPlayerScore(i)) >=  fragLimit) then
					EndMatch();
				end
			end
		end
	end


end


function PlayerConnect(player)

	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1 DeathMatch w/o Armor", "#GES_GP_INTRO");
	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1", "#GES_GP_HELP");

end


function PlayerSay( player, text )
 
	if (text == "!help") then
 
		PrintHelp( player );
		return true;

	else
		return false;
	end
 
	return false;
end

function PrintHelp( player )
 
	ClientPrintPlayer(player, HUD_PRINTTALK, "------------------------------------------------------------------");
	ClientPrintPlayer(player, HUD_PRINTTALK, "         Gameplay: %s1", "Deathmatch w/o Armor");
	ClientPrintPlayer(player, HUD_PRINTTALK, "------------------------------------------------------------------");
	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1", "#GES_GP_DEATHMATCH_H1"); 
	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1", "#GES_GP_DEATHMATCH_H2");
	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1", "#GES_GP_DEATHMATCH_H3");
	ClientPrintPlayer(player, HUD_PRINTTALK, "%s1", "#GES_GP_DEATHMATCH_H4");
	ClientPrintPlayer(player, HUD_PRINTTALK, "------------------------------------------------------------------");
 
end