from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

#Your weapons are INVINCIBLE! Alas, you are not...

class LTK(PYBaseGamePlay):
	def __init__(self):
		super(LTK, self).__init__()

	def GetPrintName(self):
		return "#GES_GP_LTK_NAME"
		
	def GetHelpString(self):
		return "#GES_GP_LTK_HELP"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team LTK"
		else:
			return "LTK"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
		self.SetDamageMultiplier( 1000 )
		self.LoadConfig()
	
	def OnUnloadGamePlay(self):
		self.SetDamageMultiplier( 1 )
	
	def ClientConnect(self, player):
		player.SetDamageMultiplier( 1000 )
	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()
		
	def OnPlayerKilled(self, victim, killer, weapon):
		#what exactly got killed?
		if not victim:
			return
		
		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return
		
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
			team.IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )

	def SetDamageMultiplier(self, amount):
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			player.SetDamageMultiplier(amount)
