from GamePlay import PYBaseGamePlay
from Utils.GEPlayerTracker import GEPlayerTracker
from random import randint
import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

	#    #    #    #    #    #    #    #    #
	#            Special Thanks <3          #
	#    #    #    #    #    #    #    #    #
	#  E-S and KillerMonkey for answering   #
	#  and putting up with all my annoying  #
	#  questions. WNx for being the best    #
	#  clan in the world, the dev team for  #
	#  making such an amazing game (I did   #
	#  get inspiration from the official    #
	#  gameplays). Thanks Falko for the     #
	#  idea of giving power back w/ knife   #
	#  kill - WNxEuphonic                   #
	#    #    #    #    #    #    #    #    #

# Excluding Proximity Mines, this is every weapon in the game in the style ("weapon", "plural print name", weapon amount ##). If you modify this, you do NOT have to modify anything else if you use self.crCustomList = 1! Sweet, right?
crWeaponList = [("pp7", "PP7s", 20), ("pp7_silenced", "Silenced PP7s", 24), ("dd44", "DD44s", 19),("sniper_rifle", "Sniper Rifles", 35), ("silver_pp7", "Silver PP7s", 15), ("golden_pp7", "Golden PP7s", 15), ("cmag", "Cougar Magnums", 20), ("golden_gun", "Golden Guns", 9), ("klobb", "Klobbs", 30), ("zmg", "ZMGs", 50), ("d5k", "D5Ks", 50), ("d5k_silenced", "Silenced D5Ks", 55), ("rcp90", "RCP90s", 100), ("phantom", "Phantoms", 60), ("kf7", "KF7s", 60), ("ar33", "AR33s", 60), ("shotgun", "Shotguns", 12), ("auto_shotgun", "Automatic Shotguns", 12), ("grenade", "Grenades", 3), ("remotemine", "Remote Mines", 5), ("grenade_launcher", "Grenade Launchers", 6), ("rocket_launcher", "Rocket Launchers", 3), ("knife_throwing", "Throwing Knives", 4), ("moonraker", "Moonraker Lasers", 1), ("knife", "Melee Only", 1)]
crWeaponListLength = len(crWeaponList) - 1
class CasinoRoyale(PYBaseGamePlay):
	# Tracks whether a player has used their power yet
	USED_POWER = "Has Player Used Power?"
	SWITCHING_TEAMS = "Is The Player Switching Teams?"
	CR_WEAPSGIVEN = "Has Player Been Given Spawn Weapons?"
	
	def __init__(self):
		super(CasinoRoyale, self).__init__()
		# Defines new variable that will track the current weapon, when created it's outside of the weaponlist length
		self.crIndex = crWeaponListLength + 1
		# Defines new variable that will be the length of each weapon, MUST BE MULTIPLE OF TEN
		self.crTimerMax = 40 * 10
		# Defines new variable that will keep track of the time of the current weapon
		self.crTimer = self.crTimerMax
		# Creates player tracker
		self.crtracker = GEPlayerTracker()
		# Defines a toggle that says if round is active or not
		self.crRoundActive = False
		# Next two keep track of how many kills that team has had during the current weapon round
		self.crJanusRoundScore = 0
		self.crMI6RoundScore = 0
		
		# # # # # # # # # # # # # # # # # # # # # # # # # # # #
		
		#   IF YOU CHANGE crWeaponList SET crCustomList TO 1  #
		
		# # # # # # # # # # # # # # # # # # # # # # # # # # # #
		
		self.crCustomList = 0
		
		# # # # # # # # # # # # # # # # # # # # # # # # # # # #
		# # # # # # # # # # # # # # # # # # # # # # # # # # # #

	def crWeightedIndex(self, crPreviousIndex):
		crRandomGroup = randint(1, 5)
		crNextIndex = crPreviousIndex
		if crPreviousIndex <= 7:
			if not crRandomGroup == 1:
				self.crIndex = randint(8, 24)
			else:
				while crNextIndex == crPreviousIndex:
					crNextIndex = randint(0, 7)
				self.crIndex = crNextIndex
		elif crPreviousIndex <= 14:
			if not crRandomGroup == 1:
				if randint(0,1) == 1: self.crIndex = randint(0, 7)
				else: self.crIndex = randint(15, 24)
			else:
				while crNextIndex == crPreviousIndex:
					crNextIndex = randint(8, 14)
				self.crIndex = crNextIndex
		else:
			if not crRandomGroup == 1:
				self.crIndex = randint(0, 14)
			else:
				while crNextIndex == crPreviousIndex:
					crNextIndex = randint(15, 24)
				self.crIndex = crNextIndex	
	
	def crNewIndex(self):
		#THIS FUNCTION REPLACES THE PRIOR INDEX WITH A NEW RANDOM ONE#
		# Get previous weapon index
		crPreviousIndex = self.crIndex
		if self.crCustomList == 1:
			crNextIndex = crPreviousIndex
			# While the previous index is the same as our next index, this will loop thus preventing same weapon twice in a row
			while crNextIndex == crPreviousIndex:
				crNextIndex = randint(0, crWeaponListLength)
			# Update global Index
			self.crIndex = crNextIndex
		else:
			self.crWeightedIndex(crPreviousIndex)
		# Get print name by first finding tuple of weapon...
		if self.crIndex > crWeaponListLength:
					self.crIndex = crWeaponListLength
		crTemp = crWeaponList[self.crIndex]
		# ...then by getting the second part of the tuple
		crPrintName = crTemp[1]
		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^xCurrent Weapon: ^i" + crPrintName)
	
	def crUpdatePlayers(self):
		GEUtil.EmitGameplayEvent( "cr_weaponchange" )
		#THIS FUNCTION CYCLES THROUGH EACH PLAYER CALLING CRSWITCHWEAPONS#
		# Get new index
		crNextIndex = self.crIndex
		# Cycle through players updating their weapons
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			self.crSwitchWeapons(player, crNextIndex)
			GEUtil.PlaySoundToPlayer( player, "GEGamePlay.Token_Drop_Enemy", True )

	def crUpdatePowers(self):
		crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
		if not crPowerSet == 0:
			#THIS FUNCTION CYCLES THROUGH EACH PLAYER SETTING USED_POWER TO FALSE#
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				self.crtracker.SetValue( player, self.USED_POWER, False )
				GEUtil.InitHudProgressBarPlayer(player, 1, "Power", 0, float(self.crTimerMax), .59, .03, 35, 10, GEUtil.CColor(173, 216, 230, 240) )
	
	def crSwitchWeapons(self, player, crNextIndex):
		#THIS FUNCTION TAKES A PLAYER'S WEAPON, GIVES THEM THEIR MELEE WEAPON, THEN GIVES THEM THE CURRENT INDEXED WEAPON
		# Get the new weapon print name, first by calling the tuple for that weapon...
		crTemp = crWeaponList[crNextIndex]
		# ...then by getting the first part of the tuple for weapon name, then get the ammo amount by the third part of the tuple
		crAmmo = crTemp[2]
		crWeapon = "weapon_" + crTemp[0]
		# Take away start weapons or currently carried weapons
		player.StripAllWeapons()
		# Get start weapon value
		crStarter = int(GEUtil.GetCVarValue("ge_startarmed"))
		# If value says give knife, give knife. If slappers, give slappers
		if crStarter == 0 or crStarter == 3:
			player.GiveNamedWeapon("weapon_slappers", 0)
		else:
			player.GiveNamedWeapon("weapon_knife", 0)
		# Give player correct weapon, ignore if weapon is knife
		if crWeapon == "weapon_knife":
			pass
		else:
			player.GiveNamedWeapon(crWeapon, crAmmo)
			player.SwitchToWeapon(crWeapon)
		self.crtracker.SetValue(player, self.CR_WEAPSGIVEN, True)

	def crAddTeamScore(self, team, amount):
		# First see if team scoring
		if int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
		# Now check which team is being edited, then add correct amount
			if team == GEGlobal.TEAM_MI6:
				self.crMI6RoundScore += amount
			elif team == GEGlobal.TEAM_JANUS:
				self.crJanusRoundScore += amount
		# Now update everyone's team score HUDs, cycle through then update
			for i in range(32):			
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer( i )
				GEUtil.ConfigHudProgressBarPlayer( player, 2, "MI6: " + str(self.crMI6RoundScore), GEUtil.CColor(14,139,237,200) )
				GEUtil.ConfigHudProgressBarPlayer( player, 3, "Janus: " + str(self.crJanusRoundScore), GEUtil.CColor(224,18,18,200) )
		#DEBUG#GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "Team Score Edited " + str(team) + " " + str(amount))#DEBUG#
		
	def crResetTeamScore(self):
		# First set both teams scores to zero
		self.crMI6RoundScore = 0
		self.crJanusRoundScore = 0
		# Now update everyone's team score HUDs
		for i in range(32):			
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer( i )
			GEUtil.ConfigHudProgressBarPlayer( player, 2, "MI6: " + str(self.crMI6RoundScore), GEUtil.CColor(14,139,237,200) )
			GEUtil.ConfigHudProgressBarPlayer( player, 3, "Janus: " + str(self.crJanusRoundScore), GEUtil.CColor(224,18,18,200) )
		#DEBUG#GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "Team Scores Reset")#DEBUG#
	
	def crTeamScoreTab(self):
		# First check if tie
		if self.crMI6RoundScore == self.crJanusRoundScore:
		# Now check if both teams have any score, if they don't then we just skip to resetting the scores
			if self.crMI6RoundScore == self.crJanusRoundScore == 0:
				pass
			else:
		# If tie and non-zero, then we print it's a tie, give both teams a point, and emit event
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^iBoth teams^x scored the same number of kills, both teams get a point!")
				GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6).IncrementRoundScore( 1 )
				GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS).IncrementRoundScore( 1 )
				GEUtil.EmitGameplayEvent( "cr_team_tie", str(GEGlobal.TEAM_MI6), str(GEGlobal.TEAM_JANUS) )
		# Since non-tie, find winning team, print so, give winning team point, then emit gameplay events for winning/losing point
		elif self.crMI6RoundScore > self.crJanusRoundScore:
			GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^iMI6^x scored the most kills and got a point!")
			GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6).IncrementRoundScore( 1 )
			GEUtil.EmitGameplayEvent( "cr_team_win", str(GEGlobal.TEAM_MI6) )
			GEUtil.EmitGameplayEvent( "cr_team_lose", str(GEGlobal.TEAM_JANUS) )
		elif self.crMI6RoundScore < self.crJanusRoundScore:
			GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^iJanus^x scored the most kills and got a point!")
			GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS).IncrementRoundScore( 1 )
			GEUtil.EmitGameplayEvent( "cr_team_win", str(GEGlobal.TEAM_JANUS) )
			GEUtil.EmitGameplayEvent( "cr_team_lose", str(GEGlobal.TEAM_MI6) )
		# At the end, reset scores (no matter which of the above paths we took)
		self.crResetTeamScore()
			
		

	#    #    #    #    #    #    #    #    #
	#        Above are custom functions     #
	#    #    #    #    #    #    #    #    #
	
	def CanPickupEntity(self, player, entity):
		#THIS FUNCTION GETS THE CURRENT WEAPON NAME THEN GIVES ALTERNATIVE AMMO IF PICKED UP ITEM IS AMMO#
		# Get the current weapon print name, first by calling the tuple for that weapon...
		if self.crIndex > crWeaponListLength:
					self.crIndex = crWeaponListLength
		crTemp = crWeaponList[self.crIndex]
		# ...then by getting the first part of the tuple
		crWeapon = crTemp[0]
		crAmmo = crTemp[2]
		crWeapon = "weapon_" + crWeapon
		# Get picked up item type
		crItem = entity.GetClassname()
		# Check to see if ammo crate or not, if so give alternative ammo
		if crItem.startswith("ge_ammo"):
			player.GiveNamedWeapon(crWeapon, crAmmo)
		return True

	def ShouldForcePickup(self, player, item):
		#THIS FUNCTION FORCES PICKUP OF AMMO CRATES, PREVENTS FORCING PICKUP OF OTHER ITEMS#
		# Get item type
		crItem = item.GetClassname()
		# If ammo crate, force pickup
		if crItem.startswith("ge_ammo"):
			return True
		# Else, do not force pickup
		else:
			return False
	
	def CanPlayerHaveWeapon(self, player, weapon ):
		if not self.crtracker.GetValue( player, self.CR_WEAPSGIVEN ):
			return True
		#THIS FUNCTION KEEPS PLAYERS FROM PICKING UP WEAPONS THAT AREN'T THEIR STARTER WEAPON OR THEIR MELEE WEAPON#
		if not weapon or not player:
			return False
		# Get the current weapon print name, first by calling the tuple for that weapon...
		if self.crIndex > crWeaponListLength:
					self.crIndex = crWeaponListLength
		crTemp = crWeaponList[self.crIndex]
		# ...then by getting the first part of the tuple
		crWeapon = crTemp[0]
		# Get weapon's name
		name = weapon.GetClassname().replace('weapon_', '').lower()
		# Check against allowed weapons
		if  name == crWeapon or name == "slappers" or name == "knife":
			return True
		else:
			return False

	def OnPlayerSpawn(self, player, isFirstSpawn):
		# We keep track of whether player is switching teams by putting to False once they spawn
		self.crtracker.SetValue( player, self.SWITCHING_TEAMS, False )
		# Give them weapon progress bar
		GEUtil.InitHudProgressBarPlayer(None, 0, "Next\nWeapon", 1, float(self.crTimerMax), -1, .04, 130, 12, GEUtil.CColor(220,220,220,240) )
		crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
		# If team scoring, give them HUD for team scores
		if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
			GEUtil.InitHudProgressBarPlayer(player, 2, "MI6: " + str(self.crMI6RoundScore), 0, float(self.crTimerMax), .015, .47, 5, 5, GEUtil.CColor(14,139,237,200) )
			GEUtil.InitHudProgressBarPlayer(player, 3, "Janus: " + str(self.crJanusRoundScore), 0, float(self.crTimerMax), .015, .53, 5, 5, GEUtil.CColor(224,18,18,200) )
		# If power is enabled, give them power indicator if they have power
		if not crPowerSet == 0:
			if not self.crtracker.GetValue( player, self.USED_POWER):
				GEUtil.InitHudProgressBarPlayer(player, 1, "Power", 0, float(self.crTimerMax), .59, .03, 35, 10, GEUtil.CColor(255,69,0, 240) )
		crCurrentIndex = self.crIndex
		# Give player correct weapons
		self.crSwitchWeapons(player, crCurrentIndex)
		# Display popup help for first spawn
		if isFirstSpawn:
			crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
			GEUtil.ShowPopupHelp( player, "Battle Royale", "The round has begun and a random weapon has been chosen! When the timer runs out, all players will receive the same random weapon.\nPress H to continue", "", 9)
			if not crPowerSet == 0:
				GEUtil.ShowPopupHelp( player, "Your Hidden Power", "Once per round, you may hit your '!voodoo' key and shorten the current weapon by an amount depending on the number of players\nPress H to continue", "", 9)
				GEUtil.ShowPopupHelp( player, "P(t)=I(t)V(t)", "You may restore your power after you have used it by scoring a slapper or knife kill. You can check to see if you have a power by looking at the top of your display.\nPress H to continue", "", 9)
		# Next only displays if team scoring
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				GEUtil.ShowPopupHelp( player, "Team Scoring", "On the left side of your screen is the number of kills each team has scored with this weapon. The team with the most kills at the end of the weapon timer scores 1 point\nPress H to continue", "", 9)
			GEUtil.ShowPopupHelp( player, "By WNxEuphonic", "Like this gamemode? Try Casino Royale LTK! Special thanks to E-S, KillerMonkey, WNx and WNxBadPlayer.", "", 6)
		# If it's been long enough since the last weapon switch, we display to them the current weapon
			if self.crTimer <= self.crTimerMax - 15:
				# Get print name by first finding tuple of weapon...
				if self.crIndex > crWeaponListLength:
					self.crIndex = crWeaponListLength
				crTemp = crWeaponList[self.crIndex]
				# ...then by getting the second part of the tuple
				crPrintName = crTemp[1]
				GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^xCurrent Weapon: ^i" + crPrintName)

	def OnPlayerConnect(self, player):
		self.crtracker.Track(player)
		self.crtracker.SetValue( player, self.USED_POWER, False )
		self.crtracker.SetValue( player, self.CR_WEAPSGIVEN, False )

	def OnPlayerDisconnect(self, player):
		self.crtracker.Drop( player )
	
	def OnRoundBegin(self):
		# The next thing checks if round is in-progress
		self.crRoundActive = True
		# The rest is all updating the new weapon, timers, etc and player/team scores
		GEMPGameRules.ResetAllPlayersScores()
		# Disable weapons from spawning
		GEMPGameRules.DisableWeaponSpawns()
		# Get new index (if not first round, will ignore last weapon used)
		self.crTimer = self.crTimerMax
		self.crNewIndex()
		self.crUpdatePowers()
		self.crResetTeamScore()

	def OnRoundEnd(self):
		self.crRoundActive = False
		# Check is team scoring
		if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
			self.crTeamScoreTab()
		# Update all players saying weapons have not been given
		for i in range(32):			
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer( i )
			self.crtracker.SetValue( player, self.CR_WEAPSGIVEN, False )
	
	def OnThink(self):
		# Subtract timer if not kill timer only
		if int(GEUtil.GetCVarValue("cr_killtimer")) != 1:
			self.crTimer -= 1
		#DEBUG# GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, str(self.crTimer))
		# If timer is greater than zero, update timer bar
		if self.crTimer >= 0:
			GEUtil.UpdateHudProgressBarPlayer(None, 0, float(self.crTimer))
		# If less than zero, the timer has ended and everyone needs a new index. If team scoring, tab scores
		if self.crTimer <= 0:
			self.crTimer = self.crTimerMax
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				self.crTeamScoreTab()
			self.crNewIndex()
			self.crUpdatePlayers()

	def OnPlayerTeamChange(self, player, oldTeam, newTeam):
		# This helps tell the difference between suicide by switching teams and suicide by gameplay
		if player != None and oldTeam != GEGlobal.TEAM_SPECTATOR and newTeam != GEGlobal.TEAM_SPECTATOR:
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				self.crtracker.SetValue( player, self.SWITCHING_TEAMS, True )
		return player

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "cr_timer":
			GEUtil.RemoveHudProgressBarPlayer(None, 0)
			self.crTimerMax = int(newvalue) * 10
			if self.crTimer >= int(newvalue):
				self.crTimer = int(newvalue)
			GEUtil.InitHudProgressBarPlayer(None, 0, "Next\nWeapon", 1, float(self.crTimerMax), -1, .04, 130, 12, GEUtil.CColor(220,220,220,240) )
		
		if name == "cr_teamscoring" and GEMPGameRules.IsTeamplay():
			if int(newvalue) == 0 and int(oldvalue) == 1:
				GEMPGameRules.ResetAllTeamsScores()
				self.crResetTeamScore()
				GEMPGameRules.EndRound(False)
				for i in range(32):
					if not GEUtil.IsValidPlayerIndex(i):
						continue
					GEUtil.RemoveHudProgressBarPlayer(None, 2)
					GEUtil.RemoveHudProgressBarPlayer(None, 3)
					player = GEUtil.GetMPPlayer(i)
			elif int(newvalue) == 1 and int(oldvalue) == 0:
				self.crResetTeamScore()
				GEMPGameRules.ResetAllTeamsScores()
				GEMPGameRules.EndRound(False)
				for i in range(32):
					if not GEUtil.IsValidPlayerIndex(i):
						continue
					player = GEUtil.GetMPPlayer(i)
					GEUtil.InitHudProgressBarPlayer(player, 2, "MI6: " + str(self.crMI6RoundScore), 0, float(self.crTimerMax), .015, .47, 5, 5, GEUtil.CColor(14,139,237,200) )
					GEUtil.InitHudProgressBarPlayer(player, 3, "Janus " + str(self.crJanusRoundScore), 0, float(self.crTimerMax), .015, .53, 5, 5, GEUtil.CColor(224,18,18,200) )
				
		elif name == "cr_power":
			crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
			if crPowerSet == 0:
				for i in range(32):
					if not GEUtil.IsValidPlayerIndex(i):
						continue
					player = GEUtil.GetMPPlayer(i)
					GEUtil.RemoveHudProgressBarPlayer(player, 1)
			else:
				for i in range(32):
					if not GEUtil.IsValidPlayerIndex(i):
						continue
					player = GEUtil.GetMPPlayer(i)
					if not self.crtracker.GetValue( player, self.USED_POWER):
						GEUtil.InitHudProgressBarPlayer(player, 1, "Power", 0, float(self.crTimerMax), .59, .03, 35, 10, GEUtil.CColor(255,69,0, 240) )
	
		elif name == "ge_teamplay" and newvalue == 0:
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				GEUtil.RemoveHudProgressBarPlayer(None, 2)
				GEUtil.RemoveHudProgressBarPlayer(None, 3)
			
	def OnPlayerSay(self, player, text):
		if text == "!current":
			# Get print name by first finding tuple of weapon...
			if self.crIndex > crWeaponListLength:
					self.crIndex = crWeaponListLength
			crTemp = crWeaponList[self.crIndex]
			# ...then by getting the second part of the tuple
			crPrintName = crTemp[1]
			GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^xCurrent Weapon: ^i" + crPrintName)
			return True

		elif text == "!voodoo":
			crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
			if crPowerSet == 0 or player.GetTeamNumber() == GEGlobal.TEAM_SPECTATOR:
				GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^w[GAMEPLAY]^m Cannot use power while in spectator mode.")
				return True
			else:
				if self.crtracker.GetValue( player, self.USED_POWER):
					GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^w[GAMEPLAY]^m You have already used your power!")
				elif not self.crRoundActive:
					GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^w[GAMEPLAY]^m Cannot use power after the round has finished.")
				else:
					GEUtil.EmitGameplayEvent( "cr_powerused", "%i" % player.GetUserID() )
					name = player.GetPlayerName()
					GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^i" + name + "^x used their ^wpower^x; the current weapon time has been shortened!")
					self.crtracker.SetValue( player, self.USED_POWER, True)
					GEUtil.RemoveHudProgressBarPlayer(player, 1)
					for i in range(32):
						if not GEUtil.IsValidPlayerIndex(i):
							continue
						crPlayer = GEUtil.GetMPPlayer(i)
						GEUtil.PlaySoundToPlayer(player,"Buttons.beep_denied")
					crActivePlayers = GEMPGameRules.GetNumActivePlayers()
					if crActivePlayers >= 8:
						crTimerModify = int(.55 * self.crTimerMax)
					elif crActivePlayers >= 5:
						crTimerModify = int(.65 * self.crTimerMax)
					elif crActivePlayers >= 3:
						crTimerModify = int(.70 * self.crTimerMax)
					else:
						crTimerModify = int(.75 * self.crTimerMax)
					if crTimerModify >= self.crTimer:
						self.crTimer = 0
					else:
						self.crTimer -= crTimerModify
				return True
		
	#DEBUG	elif text == "!test":
	#		self.crGivePower(player)
	#		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, str(self.crJanusRoundScore))
	#		GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, str(self.crMI6RoundScore))
	#		self.crAddTeamScore(GEGlobal.TEAM_MI6, 1)
	#		for i in range(32):			
	#			if not GEUtil.IsValidPlayerIndex(i):
	#				continue
	#			player = GEUtil.GetMPPlayer( i )
	#			GEUtil.ConfigHudProgressBarPlayer( player, 2, "MI6: " + str(self.crMI6RoundScore), GEUtil.CColor(14,139,237,200) )
	#DEBUG			GEUtil.ConfigHudProgressBarPlayer( player, 3, "Janus: " + str(self.crJanusRoundScore), GEUtil.CColor(224,18,18,200) )
	
		return False
		
	def GetPrintName(self):
		return "Casino Royale"
		
	def GetHelpString(self):
		return "Better stay alert in this constantly evolving gamemode!\nThe round begins with all players carrying the same weapon. Every time the meter counts down a new weapon will be randomly selected and the chaos will continue with only that weapon until the next weapon switch!\nOnce per round, you may press your '!voodoo' key lowering the amount of time until the next weapon. The amount depends on the number of active players. You can change your key under Keyboard Options."		
	
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team Casino Royale"
		else:
			return "Casino Royale"
		
	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEUtil.PrecacheSound("GEGamePlay.Token_Drop_Enemy")
		GEUtil.PrecacheSound("Buttons.beep_denied")
		GEUtil.PrecacheSound("GEGamePlay.Token_Chime")
		self.CreateCVar("cr_timer", str(int(self.crTimerMax) / 10), "Amount of time (in seconds) between weapon switches")
		self.CreateCVar("cr_power", "1", "Enable players to use their 'power' to shorten weapon times once per round")
		self.CreateCVar("cr_killtimer", "0", "If set to 1, replaces the countdown timer to the next weapon with a set number of frags; If set to 2, uses a combination of timer and kills; 0 is timer-only")
		self.CreateCVar("cr_killtimer_weight", "10", "When cr_killtimer is not set to 0, is the number of kills to the next weapon (ignoring time if cr_killtimer is 2)")
		self.CreateCVar("cr_teamscoring", "1", "When enabled, team scoring is the number of weapon 'rounds' in which that team had the most kills; changing from 0 to 1 restarts the round")
		
		GEMPGameRules.SetAllowTeamSpawns( False )
		self.LoadConfig()
		
	def OnPlayerKilled(self, victim, killer, weapon):
		#what exactly got killed?
		if not victim:
			return

		self.crtracker.SetValue( victim, self.CR_WEAPSGIVEN, False )

		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				team = victim.GetTeamNumber()
				if team == GEGlobal.TEAM_MI6:
					self.crAddTeamScore(GEGlobal.TEAM_MI6, -1)
				elif team == GEGlobal.TEAM_JANUS:
					self.crAddTeamScore(GEGlobal.TEAM_JANUS, -1)
			return
		
		crPowerSet = int(GEUtil.GetCVarValue("cr_power"))
		if not crPowerSet == 0:
			crWeaponName = weapon.GetClassname().replace('weapon_', '').lower()
			if crWeaponName == "knife" or crWeaponName == "slappers":
				self.crGivePower(killer)
				
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
			if not self.crtracker.GetValue(killer, self.SWITCHING_TEAMS):
				team = killer.GetTeamNumber()
				if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
					team = killer.GetTeamNumber()
					if team == GEGlobal.TEAM_MI6:
						self.crAddTeamScore(GEGlobal.TEAM_MI6, -1)
					elif team == GEGlobal.TEAM_JANUS:
						self.crAddTeamScore(GEGlobal.TEAM_JANUS, -1)
					#DEBUG#GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "Team Score Edited")#DEBUG#
			
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				team = killer.GetTeamNumber()
				if team == GEGlobal.TEAM_MI6:
					self.crAddTeamScore(GEGlobal.TEAM_MI6, -1)
				elif team == GEGlobal.TEAM_JANUS:
					self.crAddTeamScore(GEGlobal.TEAM_JANUS, -1)
		else:
			killer.IncrementScore( 1 )
			if int(GEUtil.GetCVarValue("cr_killtimer")) != 0:
				weight = float(GEUtil.GetCVarValue("cr_killtimer_weight"))
				self.crTimer -= float(self.crTimerMax)/float(weight)
			if GEMPGameRules.IsTeamplay() and int(GEUtil.GetCVarValue("cr_teamscoring")) == 1:
				team = killer.GetTeamNumber()
				if team == GEGlobal.TEAM_MI6:
					self.crAddTeamScore(GEGlobal.TEAM_MI6, 1)
				elif team == GEGlobal.TEAM_JANUS:
					self.crAddTeamScore(GEGlobal.TEAM_JANUS, 1)
			else:
				team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
				team.IncrementRoundScore( 1 )

	def crGivePower(self, player):
			if self.crtracker.GetValue(player, self.USED_POWER):
					GEUtil.EmitGameplayEvent( "cr_restoredpower", "%i" % player.GetUserID() )
					name = player.GetPlayerName()
					GEUtil.PlaySoundToPlayer(player,"GEGamePlay.Token_Chime")
					self.crtracker.SetValue(player, self.USED_POWER, False )
					GEUtil.InitHudProgressBarPlayer(player, 1, "Power", 0, float(self.crTimerMax), .59, .03, 35, 10, GEUtil.CColor(255,69,0, 240) )
					GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^i" + name + "^x scored a melee kill and restored their ^wpower^x!")