from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

class DrNoArmor(PYBaseGamePlay):
	def __init__(self):
		super(DrNoArmor, self).__init__()

	def GetPrintName(self):
		return "Dr. No Armor"
		
	def GetHelpString(self):
		return "Standard Deathmatch gameplay without armor!"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team Dr. No Armor"
		else:
			return "Dr. No Armor"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
	
		self.CreateCVar("dm_fraglimit", "0", "Enable frag limit for DeathMatch.")
		self.LoadConfig()
	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()
		GEMPGameRules.DisableArmorSpawns()
		
	def OnPlayerKilled(self, victim, killer, weapon):
		
		#what exactly got killed?
		if not victim:
			return
		
		#death by world
		if not killer:
			victim.IncrementScore( -1 )
			return
		
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			# In DM we add TEAM and PLAYER scores on a kill
			# We don't care if teamplay is enabled, if its not this will be ignored
			team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
			team.IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )
	
	def OnThink(self):
		fragLimit = int(GEUtil.GetCVarValue("dm_fraglimit"))
		if fragLimit != 0:
			if GEMPGameRules.IsTeamplay():
				
				teamJ = GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS);
				teamM = GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6);
			
				jScore = teamJ.GetRoundScore() + teamJ.GetMatchScore()
				mScore = teamM.GetRoundScore() + teamM.GetMatchScore()

				if jScore >= fragLimit or mScore >= fragLimit:
					GEMPGameRules.EndMatch()
			else:
				for i in range(32):
				
					if not GEUtil.IsValidPlayerIndex(i):
						continue
				
					player = GEUtil.GetMPPlayer(i)
				
					if  (player.GetMatchScore() + player.GetScore()) >=  fragLimit:
						GEMPGameRules.EndMatch()
