from GamePlay import GEScenario

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

USING_API = GEGlobal.API_VERSION_1_0_0

class DrNoDamage(GEScenario):
	def __init__(self):
		super(DrNoDamage, self).__init__()

	def GetPrintName(self):
		return "Dr.No Damage"
		
	def GetHelpString(self):
		return "That didn't hurt, get over it! V2"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team Dr.No Damage"
		else:
			return "Dr.No Damage"

	def OnPlayerSay(self, player, text):
		if text == "!voodoo":
                        GEUtil.ClientPrint(player, GEGlobal.HUD_PRINTTALK, "^iType ^y!reset ^ito warp to last checkpoint")
                        return True

		if text == "!reset":
                        player.ForceRespawn()
                        return True

		if text == "!noweapon":
                        player.StripAllWeapons()
                        return True

		if text == "!noarmor":
                        player.SetArmor( 0 )
                        return True


	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
                self.CreateCVar("nd_worlddamage", "0", "World Can Damage Players")
                self.CreateCVar("nd_selfdamage", "1", "Players Can Damage Themselves")
                self.CreateCVar("nd_otherdamage", "0", "Players Can Damage Eachother")
                self.CreateCVar("nd_slapreset", "1", "Slaping a player will respawn you.")
                self.CreateCVar("nd_tokenincentive", "1", "Token spawns at end of movement maps.")

                if int(GEUtil.GetCVarValue("nd_tokenincentive")) > 0:
                        tokenmgr = GEMPGameRules.GetTokenMgr()
                        tokenmgr.SetupToken( 'token_deathmatch', limit=1, location=GEGlobal.SPAWN_TOKEN, allow_switch=False,
                                                                glow_color=GEUtil.CColor( 50, 192, 25, 75 ), respawn_delay=30.0, print_name="Checkpoint",
                                                                view_model="models/weapons/tokens/v_flagtoken.mdl",
                                                                world_model="models/weapons/tokens/w_flagtoken.mdl" )

	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()
		
		GEMPGameRules.DisableWeaponSpawns()
		GEMPGameRules.DisableAmmoSpawns()

	def OnPlayerSpawn(self, player):
                player.SetArmor(int(GEGlobal.GE_MAX_ARMOR))
                player.StripAllWeapons()
                player.GiveNamedWeapon("weapon_slappers", 0)

	def CalculateCustomDamage(self, victim, info, health, armour):
                killer = GEEntity.GetUniqueId(GEPlayer.ToMPPlayer(info.GetAttacker()))
                target = GEEntity.GetUniqueId(victim)
                if int(GEUtil.GetCVarValue("nd_worlddamage")) == 1:
                        if killer == -1:
                                return health, armour
                else:
                        if health > 5000:
                                victim.ForceRespawn()
                        
                if int(GEUtil.GetCVarValue("nd_selfdamage")) == 1:
                        if killer == target:
                                return health, armour
                if int(GEUtil.GetCVarValue("nd_otherdamage")) == 1:
                        if killer != target and killer != -1:
                                return health, armour
                        
                if int(GEUtil.GetCVarValue("nd_slapreset")) == 1:
                        if killer != target and killer != -1:
                                if (info.GetWeapon()).GetClassname() == "weapon_slappers":
                                        killer.ForceRespawn()
                        
                armour = 0
                health = 0        
		return health, armour

	def OnPlayerKilled(self, victim, killer, weapon):
                return

        def CanPlayerHaveItem(self, player, item):
            if not item.GetClassname().startswith( "token_" ):
                return True
            else:
                if self.pltracker.GetValue( player, self.FlagsReached ) < 1:
		    GEUtil.PostDeathMessage( "^i%s has completed the map!" % player.GetPlayerName()  )
                    player.SetScoreBoardColor( GEGlobal.SB_COLOR_WHITE )
                    self.pltracker.SetValue( player, self.FlagsReached, 1 )
                    player.IncrementScore( 1 )
                    GEUtil.EmitGameplayEvent( "nd_victory", "%i" % player.GetUserID())
                return False

