from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

class KlobberingTime(PYBaseGamePlay):
	def __init__(self):
		super(KlobberingTime, self).__init__()
		
	def GetIdent(self):
		return "KlobberingTime"
		
	def GetPrintName(self):
		return "Klobbering Time"
		
	def GetHelpString(self):
		return "Basic deathmatch gameplay with one twist: only Klobb kills earn points.\n\nTeam Play: Toggleable"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team Klobbering Time"
		else:
			return "Klobbering Time"
	
	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
		self.CreateCVar("klobb_fraglimit", "0", "Enable frag limit for Klobbering Time.")
		self.LoadConfig()
		
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()	 
		
	def OnPlayerSpawn(self, player):
		# Who is spawning?
		if not player:
			return
		player.GiveNamedWeapon("weapon_klobb", 410)
		player.SwitchToWeapon("weapon_klobb")
		
	def OnPlayerKilled(self, victim, killer, weapon):
		# Derp?
		if not victim:
			return
		# Environment Death
		if not killer:
			victim.IncrementScore( -1 )
			return
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
		else:
			# Klobb kill! Get points!
			if weapon.GetClassname() == "weapon_klobb":
				team = GEMPGameRules.GetTeam(killer.GetTeamNumber())
				team.IncrementRoundScore( 1 )
				killer.IncrementScore( 1 )
			
	def OnThink(self):
		fragLimit = int(GEUtil.GetCVarValue("klobb_fraglimit"))
		if fragLimit != 0:
			if GEMPGameRules.IsTeamplay():
				teamJ = GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS);
				teamM = GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6);
				jScore = teamJ.GetRoundScore() + teamJ.GetMatchScore()
				mScore = teamM.GetRoundScore() + teamM.GetMatchScore()
				if jScore >= fragLimit or mScore >= fragLimit:
					GEMPGameRules.EndMatch()
			else:
				for i in range(32):
					if not GEUtil.IsValidPlayerIndex(i):
						continue
					player = GEUtil.GetMPPlayer(i)
					if (player.GetMatchScore() + player.GetScore()) >= fragLimit:
						GEMPGameRules.EndMatch()