## OHMSS by VC
## Release 0001

from GamePlay import PYBaseGamePlay
from Utils.GEPlayerTracker import GEPlayerTracker
import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal
import random

#///////////////////////////////////////////////////////////////////////////////

EP_SHOUT_COLOR = GEUtil.CColor(240,200,120,170)

def ep_distribute_damage(player, impact):
	if player != None:
		armour_share = ep_tf(impact >= player.GetArmor(), impact, player.GetArmor())
		health_share = impact - armour_share
		return health_share, armour_share
	return impact, 0

def ep_goldeneye_handicap(hc):
	return 2.0 ** (float(hc) / 3.0)

def ep_id_by_entity(ent):
	if ent != None:
		return GEEntity.GetUniqueId(ent)
	return 0

def ep_player_by_id(uid):
	return GEPlayer.ToMPPlayer(GEEntity.GetEntByUniqueId(uid))

def ep_sameplayer(player_a, player_b):
	if player_a != None and player_b != None:
		return ep_id_by_entity(player_a) == ep_id_by_entity(player_b)
	return False

def ep_shout(msg):
	GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, msg)
	GEUtil.HudMessage(None,msg,-1,-1,EP_SHOUT_COLOR,2.0)
	return msg

def ep_tf(v, t, f):
	if v:
		return t
	return f

def ep_weapon_by_info(info):
	weaponsurrogate = info.GetWeapon()
	if weaponsurrogate != None:
		weapon = GEWeapon.ToGEWeapon(weaponsurrogate)
		if weapon != None:
			return weapon.GetClassname().lower()
	return "weapon_paintbrush"


#///////////////////////////////////////////////////////////////////////////////

class OHMSS(PYBaseGamePlay):
	def __init__(self):
		super(OHMSS, self).__init__()
		self.ohmss_declare_scenario_data()

	def ohmss_clamp_score(self, player):
#		ep_shout("cs")
		if player != None:
			if player.GetScore() < 0:
				player.SetScore(0)
			if player.GetScore() > len(self.grace) - 2:
				GEMPGameRules.EndRound()
				player.SetScore(len(self.grace)-1)
			return player.GetScore()
		return 0

	def ohmss_credit_assailant(self, killer, impact, impact_base):
#		ep_shout("ca")
		if killer != None:
			index = self.ohmss_index_of_player(killer)
			if index > -1:
				# Evaluate quality of attack
				if impact_base < self.base[killer.GetScore()]:
					self.misses[index] += 1
				# Level up on goal achievement
				self.tonext[index] -= impact
				if self.tonext[index] < 1: # Damage goal achieved.
					if self.ohmss_reward_accuracy():
						if self.misses[index] <= self.grace[killer.GetScore()]:
							self.pow[index] += 1
							GEUtil.PlaySoundToPlayer(killer,"GEGamePlay.Token_Chime")
							if self.misses[index] < 1: # Perfect
								#GEUtil.HudMessage(killer,"PERFECT",-1,-1,EP_SHOUT_COLOR,2.0)
								self.ohmss_notice(killer, "PERFECT")
								self.pow[index] += 1
								GEUtil.PlaySoundToPlayer(killer,"Buttons.beep_ok")
							else:
#								GEUtil.HudMessage(killer,"EXCELLENT",-1,-1,EP_SHOUT_COLOR,2.0)
								self.ohmss_notice(killer, "EXCELLENT")
					self.ohmss_level(killer, 1)
			self.ohmss_hud_update(killer)
		return killer

	def ohmss_damage_amp(self, scale):
#		ep_shout("da")
		return ep_goldeneye_handicap(0.5 * (float(scale) ** 0.605))

	def ohmss_declare_scenario_data(self):
#		ep_shout("dsd")
		self.weapon = ["weapon_golden_pp7","weapon_golden_gun","weapon_rocket_launcher","weapon_rcp90","weapon_moonraker","weapon_ar33","weapon_auto_shotgun","weapon_cmag","weapon_sniper_rifle","weapon_phantom","weapon_kf7","weapon_shotgun","weapon_zmg","weapon_dd44","weapon_klobb","weapon_knife_throwing","weapon_grenade","weapon_slappers","weapon_slappers"]
		self.base = [200,5000,200,90,100,70,40,100,70,70,50,20,50,50,40,150,200,1,1]
		self.grace = [1,1,1,2,2,2,3,3,2,4,3,4,3,3,5,3,3,0,0]
		self.uid = [0 for j in range(32)]
		self.pow = [0 for j in range(32)]
		self.tonext = [0 for j in range(32)]
		self.misses = [0 for j in range(32)]
		self.notice = [0 for j in range(32)]
		self.DAMAGE_GOAL = 320
		self.REWARD_ACCURACY_CVAR = "ohmss_reward_accuracy"
		self.REWARD_ACCURACY_DEFAULT = "1"
		self.REWARD_SCALE_CVAR = "ohmss_reward_accuracy"
		self.REWARD_SCALE_DEFAULT = "0.605"
		self.COLOR_CASH = GEUtil.CColor(180,150,30,170)
		self.COLOR_NORM = GEUtil.CColor(30,150,180,170)
		self.COLOR_EXCE = GEUtil.CColor(150,180,30,170)
		self.BAR_ESCAPE = 100
		return self

	def ohmss_equip(self, player):
#		ep_shout("eqip")
		if player != None:
			player.StripAllWeapons()
			tier_weapon = self.weapon[self.ohmss_clamp_score(player)]
			if tier_weapon == "weapon_slappers":
				player.GiveNamedWeapon("weapon_slappers",0)
			else:
				player.GiveNamedWeapon("weapon_knife",0)
				player.GiveNamedWeapon(tier_weapon, 187)
			player.SwitchToWeapon(tier_weapon)
			self.ohmss_hud_update(player)
		return player

	def ohmss_hud_update(self, player):
#		ep_shout("hudu")
		if player != None:
			index = self.ohmss_index_of_player(player)
			if index > -1:
				barcolor = self.COLOR_NORM
				if self.misses[index] <= self.grace[player.GetScore()]:
					if self.misses[index] < 1:
						barcolor = self.COLOR_CASH
					else:
						barcolor = self.COLOR_EXCE
				GEUtil.InitHudProgressBarPlayer(player, 0, "", GEGlobal.HUDPB_SHOWBAR, self.DAMAGE_GOAL, -1, .76, self.BAR_ESCAPE, 10, barcolor)
				GEUtil.UpdateHudProgressBarPlayer(player, 0, self.tonext[self.ohmss_index_of_player(player)])
				player_power = int(self.ohmss_damage_amp(self.pow[self.ohmss_index_of_player(player)]) * 100 - 100)
				if player_power > 0 and self.ohmss_reward_accuracy():
					GEUtil.InitHudProgressBarPlayer(player, 1, "Damage +%d%%" % player_power, GEGlobal.HUDPB_SHOWBAR, 0, -1, .72, 0, 0, self.COLOR_CASH)
				else:
					GEUtil.RemoveHudProgressBarPlayer(player,1)
		return player

	def ohmss_index_of_player(self, player):
#		ep_shout("iop")
		if player != None:
			for j in range(32):
				if self.uid[j] == GEEntity.GetUniqueId(player):
#					ep_shout("!iop")
					return j
#		ep_shout("!!iop")
		return -1

	def ohmss_level(self, player, delta):
#		ep_shout("level")
		if player != None:
			index = self.ohmss_index_of_player(player)
			if index > -1:
				old_score = player.GetScore()
				player.SetScore(old_score + delta)
				self.ohmss_clamp_score(player)
				if old_score >= player.GetScore():
					self.pow[index] = 0
				self.tonext[index] = self.DAMAGE_GOAL
				self.misses[index] = 0
				self.ohmss_equip(player)
			else:
				ep_shout("ERROR: Attempting to level unregistered player.")
			self.ohmss_equip(player)
			self.ohmss_hud_update(player)
		return player

	def ohmss_notice(self, player, msg):
		if player != None:
			self.notice[self.ohmss_index_of_player(player)] = 20
			GEUtil.InitHudProgressBarPlayer(player, 2, msg, GEGlobal.HUDPB_SHOWBAR, 0, -1, .64, 0, 0, self.COLOR_CASH)

	def ohmss_register_player(self, player):
#		ep_shout("regp")
		if player != None:
			self.ohmss_remove_player(player)
			for j in range(32):
				if self.uid[j] == 0:
					self.uid[j] = GEEntity.GetUniqueId(player)
#					ep_shout("!regp")
					return j
#		ep_shout("!!regp")
		return -1

	def ohmss_remove_player(self, player):
#		ep_shout("rmvp")
		if player != None:
			GEUtil.RemoveHudProgressBarPlayer(player, 0)
			j = self.ohmss_index_of_player(player)
			if j > -1:
				self.pow[j] = 0
				self.tonext[j] = 0
				self.misses[j] = 0
				self.uid[j] = 0
#				ep_shout("!rmvp")
#			else:
#				ep_shout("!!rmvp")
#		else:
#			ep_shout("!!!rmvp")
		return j

	def ohmss_reward_accuracy(self):
#		ep_shout("ra")
		return GEUtil.GetCVarValue(self.REWARD_ACCURACY_CVAR) != "0"
		return True

	def CanPlayerHaveWeapon(self, player, weapon):
#		ep_shout("CPHW ")
#		ep_shout(weapon.GetClassname().lower())
#		ep_shout(self.weapon[player.GetScore()])
		if player != None:
			if weapon.GetClassname().lower() == "weapon_knife":
				return True
			if weapon.GetClassname().lower() == self.weapon[player.GetScore()]:
				return True
		return False

	def CanPlayerRespawn(self, player):
#		ep_shout("CPR")
		return player != None

	def GetPrintName(self):
#		ep_shout("GPT")
#		return "On Her Majesty's Secret Service"
		return "OHMSS"
		
	def GetHelpString(self):
#		ep_shout("GHS")
		return "OO agents don't call for help."
		
	def GetGameDescription(self):
#		ep_shout("GGD")
		return "OHMSS"

	def GetTeamPlay(self):
#		ep_shout("GTP")
		return GEGlobal.TEAMPLAY_NONE
		
	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == self.REWARD_ACCURACY_CVAR:
			for j in range(32):
				self.pow[j] = 0

	def OnLoadGamePlay(self):
#		ep_shout("OLGP")
		self.CreateCVar(self.REWARD_ACCURACY_CVAR, self.REWARD_ACCURACY_DEFAULT, "Players do more damage when they play skillfully.")
		self.LoadConfig()
		GEUtil.PrecacheSound("GEGamePlay.Token_Chime")
		GEUtil.PrecacheSound("Buttons.beep_ok")

	def OnPlayerConnect(self, player):
#		ep_shout("OPC")
		if player != None:
			self.ohmss_register_player(player)
#		ep_shout("!OPC")
		return player
	
	def OnPlayerDisconnect(self, player):
#		ep_shout("OPD")
		if player != None:
			self.ohmss_remove_player(player)
		return player

	def OnPlayerKilled(self, victim, killer, weapon):
		if ep_sameplayer(victim,killer):
			self.ohmss_level(victim, -1)
		
	def OnPlayerSay(self, player, text):
#		if text.lower() == "!lup":
#			self.ohmss_level(player, 1)
#			return True
#		if text.lower() == "!do75":
#			self.ohmss_credit_assailant(player, 120, 120)
#			return True
#		if text.lower() == "!do25":
#			self.ohmss_credit_assailant(player, 40, 40)
#			return True
#		if text.lower() == "!do200":
#			self.ohmss_credit_assailant(player, 320, 320)
#			return True

		return False

	def OnPlayerSpawn(self, player, isFirstSpawn):
#		ep_shout("OPS")
		if player != None:
			if isFirstSpawn:
				if self.ohmss_reward_accuracy():
					GEUtil.ShowPopupHelp( player, "On Her Majesty's S.S.", "Inflict damage on your enemies and work through the arsenal.  Accurate attacks will increase your firepower." )
				else:
					GEUtil.ShowPopupHelp( player, "On Her Majesty's S.S.", "Inflict damage on your enemies and work through the arsenal.  Accuracy bonuses have been disabled by the server administrator." )
			self.ohmss_level(player,0)
		return player

	def OnPlayerTeamChange(self, player, oldTeam, newTeam):
#		ep_shout("OPTC")
		if player != None and oldTeam != GEGlobal.TEAM_SPECTATOR and newTeam == GEGlobal.TEAM_SPECTATOR:
			self.ohmss_level(player,-1)
		return player

	def OnRoundBegin(self):
#		ep_shout("ORB")
		GEMPGameRules.AllowRoundTimer( False )
		GEMPGameRules.UnlockRound()
		GEMPGameRules.DisableWeaponSpawns()
		GEMPGameRules.DisableAmmoSpawns()
		GEMPGameRules.ResetAllPlayersScores()

	def OnThink(self):
		for j in range(32):
			if self.notice[j] > 0:
				self.notice[j] -= 1
				if self.notice[j] < 1:
					GEUtil.RemoveHudProgressBarPlayer(ep_player_by_id(self.uid[j]), 2)

	def ShouldDoCustomDamage(self, victim, info, health, armour):
#		ep_shout("SDCD")
		impact = health + armour
		impact_base = impact
		killer = GEPlayer.ToMPPlayer( info.GetAttacker() )
		if victim == None:
			return health, armour
		if killer == None or ep_sameplayer(victim, killer):
			return health, armour
		if ep_weapon_by_info(info) == "weapon_slappers":
			impact = 320
			impact_base = 320
#		ep_shout(ep_weapon_by_info(info))
		if ep_weapon_by_info(info) == self.weapon[killer.GetScore()] or ep_weapon_by_info(info) == "weapon_paintbrush": # or ep_weapon_by_info(info) == "weapon_knife":
#			if impact > self.base[killer.GetScore()]: # Boom, headshot!  Amplify damage
#				if self.ohmss_index_of_player(killer) > -1:
			impact *= self.ohmss_damage_amp(self.pow[self.ohmss_index_of_player(killer)])
#				else:
#					ep_shout("Error: Unregistered player dealt damage.")
		self.ohmss_credit_assailant(killer, impact, impact_base)
		armour_share = ep_tf(impact >= victim.GetArmor(), victim.GetArmor(), impact)
		health_share = impact - armour_share
#		ep_shout("%d -> %d: %d, %d" % (impact_base, impact, health_share, armour_share))
		return health_share, armour_share
#		return ep_distribute_damage(victim, impact)
