from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

# NOTE NOTE #
# When changing the weapon list, make sure you also change the classname list
# or the weapons will not register as proper kills for the player's level
#
# The classnames for the following weapons should be substituted:
# 	grenade -> npc_grenade
# 	rocket_launcher -> npc_rocket
# 	grenade_launcher -> npc_shell
# 	[remote|timed|proximity]mine -> npc_mine  ##(ALL MINES ARE THE SAME CLASSNAME)##
#

weapList = ["golden_pp7", "golden_gun", "ar33", "rcp90", "auto_shotgun", "phantom", "d5k", "zmg", "kf7", "shotgun", "cmag", "sniper_rifle", "pp7",  "klobb", "knife_throwing", "grenade", "knife"]
weapClassName = ["golden_pp7", "golden_gun", "ar33", "rcp90", "auto_shotgun", "phantom", "d5k", "zmg", "kf7", "shotgun", "cmag", "sniper_rifle", "pp7",  "klobb", "knife_throwing", "npc_grenade", "knife"]
iMaxLevel = len(weapList)-1

class TurboGG(PYBaseGamePlay):
	def __init__(self):
		super(TurboGG, self).__init__()
		
		self.EndWarmUpTime = 0
		self.InWarmup = True
		self.StartedGame = False
		self.WaitingForPlayers = True
 
		self.iPlayersLevel = []
		self.iAlivePlayers = []
		self.bWeaponsGiven = []  # Prevents default loadout from dropping to the ground

	def GetPrintName(self):
		return "TurboGG"
		
	def GetHelpString(self):
		return "#GES_GP_GUNGAME_HELP"
		
	def GetGameDescription(self):
		if GEMPGameRules.IsTeamplay():
			return "Team TurboGG"
		else:
			return "TurboGG"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_NONE
		
	def OnLoadGamePlay(self):
		self.EndWarmUpTime = 0
		self.InWarmup = True
		self.StartedGame = False
		self.WaitingForPlayers = True
 
		self.iPlayersLevel = []
		self.iAlivePlayers = []
		self.bWeaponsGiven = []  # Prevents default loadout from dropping to the ground
		
		for i in range(32):
			self.iPlayersLevel.insert(i, 0)
			self.iAlivePlayers.insert(i, False)
			self.bWeaponsGiven.insert(i, False)
			
		self.CreateCVar("gg_avglevel", "0", "Give new players average level on join")
		self.CreateCVar("gg_warmup", "20", "The warm up time in seconds")
		self.CreateCVar("gg_deathmatch", "1", "Enable DeathMatch")
		self.LoadConfig()
		self.CreateCVar("ge_velocity", "1.5", "Velocity (speed) multiplier, range from 0.5 to 1.5.")

	def ClientConnect(self, player):
		if not player:
			return
	
		if GEUtil.GetCVarValue("gg_avglevel") != "0" and self.InWarmup == False:
			self.iPlayersLevel[player.GetIndex()] = self.AvgLevel()
		else:
			self.iPlayersLevel[player.GetIndex()] = 0

		self.iAlivePlayers[player.GetIndex()] = False
		self.bWeaponsGiven[player.GetIndex()] = False
	
	def ClientDisconnect(self, player):
		if not player:
			return
	
		self.iPlayersLevel[player.GetIndex()] = 0
		self.iAlivePlayers[player.GetIndex()] = False
		self.bWeaponsGiven[player.GetIndex()] = False
	
	def OnPlayerSay(self, player, text):
		if text == "!level":
	 
			self.PrintCurLevel( player )
			return True
	 
		elif text == "!weapons":
	 
			self.PrintWeapons( player )
			return True
	 
		elif text == "!commands":
		
			self.PrintCommands( player )
			return True

		return False

	def OnCVarChanged(self, name, oldvalue, newvalue):
		if name == "gg_deathmatch" and int(newvalue) > 0 and int(oldvalue) == 0:
			GEUtil.HudMessage( None, "Deathmatch mode was activated!", -1, -1, GEUtil.CColor(255,255,255,255), 4.0 )
			GEMPGameRules.EndRound()
		if name == "ge_velocity":
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				player.SetSpeedMultiplier( float(newvalue) )
				
	def OnRoundBegin(self):
		GEMPGameRules.AllowRoundTimer( False )
		
		GEMPGameRules.DisableWeaponSpawns()
		GEMPGameRules.DisableAmmoSpawns()
		GEMPGameRules.DisableArmorSpawns()
		
		GEMPGameRules.ResetAllPlayersScores()
		
		leadLevel = -1
		leadPlayer = -1
		tie = False

		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
		
			player = GEUtil.GetMPPlayer(i)	
			pL = self.iPlayersLevel[i]
			
			if player.GetTeamNumber() != GEGlobal.TEAM_SPECTATOR:
				if pL > leadLevel:
					leadLevel = pL
					leadPlayer = i
					tie = False
				elif pL == leadLevel:
					tie = True
					
		if GEUtil.IsValidPlayerIndex(leadPlayer) and leadLevel > 0 and leadLevel < iMaxLevel:
			if tie == True:
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^lCurrent Leader: ^yTie on Level %i" % (leadLevel+1) )
			else:
				lp = GEUtil.GetMPPlayer(leadPlayer)
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^lCurrent Leader: ^y %s ^d(Level %i)" % (lp.GetPlayerName(), leadLevel+1 ) )

		for i in range(32):
		
			if not GEUtil.IsValidPlayerIndex(i):
				continue
		
			player = GEUtil.GetMPPlayer(i)	
			
			if self.iPlayersLevel[i] != -1:
				player.IncrementScore( self.iPlayersLevel[i] + 1 )
				self.iAlivePlayers[i] = True
				self.PrintCurLevel(player)
				self.GivePlayerWeapons(player)	

		if not self.InWarmup:
			self.StartedGame = True
		else:
			self.StartedGame = False
	
	def OnRoundEnd(self):
		for i in range(32):
			self.bWeaponsGiven[i] = False
			
			if not GEUtil.IsValidPlayerIndex(i):
				continue
				
			player = GEUtil.GetMPPlayer( i )
			# Reset their match score so the match report shows their final level not an accumulation
			if GEMPGameRules.IsGameOver():
				player.SetMatchScore( 0 )
				
			player.SetScore( self.iPlayersLevel[i] + 1 )
				
	def CanPlayerHaveWeapon(self, player, weapon ):
		if not weapon or not player:
			return False
			
		# Allow the default loadout to be given to the player before GivePlayerWeapons() is called
		if not self.bWeaponsGiven[player.GetIndex()]:
			return True
 
		name = weapon.GetClassname().replace('weapon_', '').lower()
		
		pL = self.iPlayersLevel[player.GetIndex()]

		if pL < 0 or pL > iMaxLevel:
			return True
		
		if  name == weapList[pL] or name == "knife" or name == "slappers":
			return True

		return False	
	
	def CanPlayerRespawn(self, player):
		if not player:
			return False
 
		if self.StartedGame == False:
			return True

		if GEUtil.GetCVarValue("gg_deathmatch") == "0":
			return self.iAlivePlayers[player.GetIndex()]

		return True
		
	def OnPlayerSpawn(self, player):
		self.GivePlayerWeapons(player)
		player.SetScore( self.iPlayersLevel[player.GetIndex()] + 1 )
		player.SetSpeedMultiplier( float(GEUtil.GetCVarValue("ge_velocity")) )

	def OnPlayerKilled(self, victim, killer, weapon):
		if not self.StartedGame:
			return
			
		#what exactly got killed?
		if not victim:
			return		
		
		# Reset the victim getting their loadout
		self.bWeaponsGiven[victim.GetIndex()] = False
		
		#death by world
		if not killer or not weapon:
			victim.IncrementScore( -1 )
			if self.iPlayersLevel[victim.GetIndex()] > 0:
				self.iPlayersLevel[victim.GetIndex()] -= 1
			return			
			
		kId = killer.GetIndex()
		vId = victim.GetIndex()
		
		kL = self.iPlayersLevel[kId]
		vL = self.iPlayersLevel[vId]

		weapName = weapon.GetClassname().replace('weapon_', '').lower()
		
		self.iAlivePlayers[vId] = False

		if vId == kId:
	 
			if kL > 0:
				killer.IncrementScore( -1 )
				self.iPlayersLevel[kId] -= 1
	 
		elif GEMPGameRules.IsTeamplay() and killer.GetTeamNumber() == victim.GetTeamNumber():
	 
			if kL > 0:
				killer.IncrementScore( -1 )
				self.iPlayersLevel[kId] -= 1
	
		elif weapName == weapClassName[kL] or weapName == "knife" or weapName == "slappers":
	 
			if weapName == "knife" and vL > 0:
				self.iPlayersLevel[vId] -= 1
				victim.IncrementScore( -1 )
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^y%s ^lwas knifed and lost a level." % victim.GetPlayerName() )

			if weapName == "slappers":
				if vL > 0:
					self.iPlayersLevel[vId] -= 1
					victim.IncrementScore( -1 )
					GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^y%s ^lwas slapped and lost a level. ^y%s ^lgained armor!" %(victim.GetPlayerName(), killer.GetPlayerName() ) )
				else:			
					GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^y%s ^lwas slapped to death by ^y%s ^lwho gained armor!" %(victim.GetPlayerName(), killer.GetPlayerName() ) )

				killer.SetArmor( int(GEGlobal.GE_MAX_ARMOR) )
				
			GEMPGameRules.GetTeam(killer.GetTeamNumber()).IncrementRoundScore( 1 )
			killer.IncrementScore( 1 )
			
			self.iPlayersLevel[kId] += 1
	 
			if self.iPlayersLevel[kId] > iMaxLevel:
				GEMPGameRules.SetPlayerWinner(killer)
				GEMPGameRules.EndMatch()
			else:
				self.PrintCurLevel(killer)
				self.GivePlayerWeapons(killer)
				
	def OnThink(self):

		# Check for insufficient player count
		if GEMPGameRules.GetNumActivePlayers() < 2:
			GEUtil.ClientPrintAll( GEGlobal.HUD_PRINTCENTER, "Waiting For Players ..." )
			self.StartedGame = False
			self.InWarmup = False
			self.WaitingForPlayers = True
			return
		elif self.WaitingForPlayers:
			# We have a new player, end waiting and begin warmup (if set)
			self.InWarmup = True
			self.WaitingForPlayers = False
			
			warmuptime = int( GEUtil.GetCVarValue("gg_warmup") )
			if warmuptime > 0:
				self.EndWarmUpTime = GEUtil.GetTime() + warmuptime
		
		
		if self.InWarmup and GEUtil.GetTime() > self.EndWarmUpTime:
			# We finished warmup, restart the round and start the game
			self.InWarmup = False
			self.EndWarmUpTime = 0
			GEMPGameRules.EndRound(False)
			return

		elif self.InWarmup:
			# We are in warmup, display our time left
			GEUtil.ClientPrintAll( GEGlobal.HUD_PRINTCENTER, "WarmUp: %02.0f" % (self.EndWarmUpTime - GEUtil.GetTime()) )
			return

		# In DM mode we don't care about how many players are left alive
		if GEUtil.GetCVarValue("gg_deathmatch") != "0":
			return

		# Check for the number of players left alive for round end conditions
		if GEMPGameRules.IsTeamplay() == True:
			iMI6PlayersLeft = 0
			iJanusPlayersLeft = 0
			iAlivePlayers = 0
	
			for i in range(32):
			
				if not GEUtil.IsValidPlayerIndex(i):
					continue
			
				player = GEUtil.GetMPPlayer(i)		
			
				if player.IsDead() == False and player.GetTeamNumber() != GEGlobal.TEAM_SPECTATOR:
					if player.GetTeamNumber() == GEGlobal.TEAM_MI6:
						iMI6PlayersLeft += 1
						
					if player.GetTeamNumber() == GEGlobal.TEAM_JANUS:
						iJanusPlayersLeft += 1
	
			iAlivePlayers = iMI6PlayersLeft + iJanusPlayersLeft
	
			if iAlivePlayers == 1:
				for i in range(32):
				
					if not GEUtil.IsValidPlayerIndex(i):
						continue
				
					player = GEUtil.GetMPPlayer(i)		
	
					if player.IsDead() == False and player.GetTeamNumber() != GEGlobal.TEAM_SPECTATOR:
						GEMPGameRules.SetPlayerWinner(player)
	 
			if  iMI6PlayersLeft == 0 and iJanusPlayersLeft == 0:
				GEMPGameRules.EndRound()
				self.StartedGame = False

			elif  iMI6PlayersLeft == 0 and iJanusPlayersLeft > 0:

				GEMPGameRules.GetTeam(GEGlobal.TEAM_JANUS).IncrementMatchScore( 10 )
				GEMPGameRules.SetTeamWinner( GEGlobal.TEAM_JANUS )
				GEMPGameRules.EndRound()
				self.StartedGame = False

			elif  iJanusPlayersLeft == 0 and iMI6PlayersLeft > 0:

				GEMPGameRules.GetTeam(GEGlobal.TEAM_MI6).IncrementMatchScore( 10 )
				GEMPGameRules.SetTeamWinner( GEGlobal.TEAM_MI6 )
				GEMPGameRules.EndRound()
				self.StartedGame = False			
	
		else:
			if GEMPGameRules.GetNumAlivePlayers() <= 1:
				GEMPGameRules.EndRound()
				
				
#-------------------#
# Utility Functions #
#-------------------#

	def PrintCurLevel(self, player):
		if not player:
			return

		if self.iPlayersLevel[player.GetIndex()] > iMaxLevel:
			return
	
		if self.iPlayersLevel[player.GetIndex()] >= 0:
			weapName = GEUtil.WeaponPrintName( "weapon_%s" % weapList[self.iPlayersLevel[player.GetIndex()]] )
			GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "%s1 %s2", "^lLevel %i: ^y" % (self.iPlayersLevel[player.GetIndex()]+1), "%s" % (weapName))
			
		else:
			GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^lYou are currently not playing" )
	 

	def GivePlayerWeapons(self, player ):
		if not player:
			return 
	 
		if player.IsDead() or self.iPlayersLevel[player.GetIndex()] < 0 or self.iPlayersLevel[player.GetIndex()] > iMaxLevel:
			return
	 
		player.StripAllWeapons()
	 
		player.GiveNamedWeapon("weapon_slappers", 0)
		player.GiveNamedWeapon("weapon_knife", 0)
	 
		curWeap = "weapon_%s" % weapList[self.iPlayersLevel[player.GetIndex()]]
	 
		if self.iPlayersLevel[player.GetIndex()] != iMaxLevel:
			if curWeap == "weapon_grenade":
				player.GiveNamedWeapon(curWeap, 1)
			else:
				player.GiveNamedWeapon(curWeap, 90)
		
			player.SwitchToWeapon( curWeap )
			
		else:
			player.SwitchToWeapon( "weapon_knife" )
		
		self.bWeaponsGiven[player.GetIndex()] = True

	def AvgLevel(self):

		level = 0
		count = 0

		for i in range(32):
		
			if not GEUtil.IsValidPlayerIndex(i):
				continue
		
			player = GEUtil.GetMPPlayer(i)
		
			if player.GetTeamNumber() != GEGlobal.TEAM_SPECTATOR:
				level = level + self.iPlayersLevel[i]
				count +=  1

		if count == 0:
			return 0
		 
		return int(level / count)
	 
	def PrintWeapons(self, player ):
	 
		if not player:
			return	 
	 
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^l----------------------------------------------------")
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "         GunGame Weapons Order")
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^l----------------------------------------------------")

		for i in range(iMaxLevel):
			GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "%i: %s" % (i, GEUtil.WeaponPrintName("weapon_%s" % weapList[i])))
	
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^l----------------------------------------------------")
	
	def PrintCommands(self, player ):

		if not player:
			return
	
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^l-------------------------------------")
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "Type !level for current level")
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "Type !weapons for weapon order")
		GEUtil.ClientPrintPlayer(player, GEGlobal.HUD_PRINTTALK, "^l-------------------------------------")
