from GamePlay import PYBaseGamePlay
from Utils.GEPlayerTracker import GEPlayerTracker
import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal
import math

class Uplink(PYBaseGamePlay):
	
	# GAMEPLAY BY WNXEUPHONIC
	# SERVER PLUGIN BY WNXBADPLAYER
	# SPECIAL THANKS TO E-S, KILLERMONKEY AND ALL OF THE TESTERS
	# PRESENTED WITHOUT WARRANTY, FREE TO USE
	# IF YOU MODIFY THE CODE, KEEP PRIMARY CREDIT TO WNXEUPHONIC
	# IF YOU USE THE CODE IN A NEW GAMEPLAY, ETC KEEP SOME CREDIT TO WNXEUPHONIC
	# CAPS LOCK? WHAT'S THAT!?!?!
	
	UP_ASSOCIATED_CP = False #Used in PlayerTracker to store which Token the player is associated with
	
	def __init__(self):
		super(Uplink, self).__init__()
		self.pltracker = GEPlayerTracker()
		
		# Radar Colors -->
		self.upColorNeutral = GEUtil.CColor(255,255,255, 255)
		self.upColorMI6 = GEUtil.CColor(0,150,255,255)
		self.upColorJanus = GEUtil.CColor(255,0,0,255)
		
		# Glow Color -->
		self.upGlow = GEUtil.CColor(255,180,225,170)
		
		# Scoreboard Colors -->
		self.upScoreDefault = GEGlobal.SB_COLOR_NORMAL
		self.upScoreWhite = GEGlobal.SB_COLOR_WHITE
		
		# Token Lists -->
		self.tokenslist = []
		self.contestedlist = []
		self.TOKENowner = dict() #Default to False
		self.MI6timer = dict() #Default to 0
		self.JANUStimer = dict() #Default to 0
		self.TOKENpoints = dict() #Default to 0
		
		# Control Point Stats -->
		self.upCPRadius = 135
		self.upCaptureTimer = 60
		self.upCPPointBreak = 70	# THIS MUST BE GREATER THEN self.upCaptureTimer!
		
		# HUD Message -->
		self.upMOwned = "You Own This Control Point"
		
		# Initial Player -->
		self.upIPlayers = 0
		
		# Plugin -->
		self.upPRed = 2
		self.upPBlue = 1
		self.upPWhite = 3
		

	def GetPrintName(self):
		return "Uplink"
		
	def GetHelpString(self):
		return "Help your team capture the Control Points! At the start of the round, a number of Control Points will spawn around the map. Step on them to take control of them for your team. Your team gets points for each Control Point they own."
		
	def GetGameDescription(self):
		return "Uplink"

	def GetTeamPlay(self):
		#Due to limitations in the radar system, only teamplay is currently allowed
		return GEGlobal.TEAMPLAY_ALWAYS
		
	def OnLoadGamePlay(self):
		GEMPGameRules.SetAllowTeamSpawns( False )
		GEUtil.PrecacheSound( "GEGamePlay.Token_Grab" )
		GEUtil.PrecacheSound( "GEGamePlay.Token_Drop_Enemy" )
		# Spawn a Flag token where DM tokens normally spawn, and force radar on.
		GEMPGameRules.GetTokenMgr().AddTokenType( "token_deathmatch" , 1, GEGlobal.SPAWN_TOKEN )
		GEMPGameRules.GetTokenMgr().SetTokenGlow( "token_deathmatch" , True, self.upGlow )
		GEMPGameRules.GetTokenMgr().SetTokenRespawnDelay( "token_deathmatch" , 0 )
		GEMPGameRules.GetTokenMgr().SetCustomTokenSettings( "token_deathmatch" , "models/weapons/tokens/w_flagtoken.mdl", "models/weapons/tokens/w_flagtoken.mdl", "Flag" )
		GEMPGameRules.GetRadar().SetForceRadar( True )

		self.LoadConfig()

	def OnRoundBegin(self):
		# Reset scores, spawn new tokens and clear contested tokens list
		GEMPGameRules.GetTokenMgr().SetTokenSpawnLimit( "token_deathmatch" , self.upControlPointsNumber() )
		GEMPGameRules.ResetAllPlayersScores()
		GEMPGameRules.ResetAllPlayerDeaths()
		self.contestedlist = []

	def OnRoundEnd(self):
		GEMPGameRules.GetRadar().DropAllContacts()
		self.upClearCPs()

	def OnPlayerConnect(self, player):
		self.pltracker.Track(player)
		
	def OnPlayerDisconnect(self, player):
		self.pltracker.Drop(player)
	
	def OnPlayerTeamChange(self, player, oldTeam, newTeam):
		self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, False )
		player.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
		
	def OnPlayerSpawn(self, player, isFirstSpawn):
		self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, False )
		GEUtil.RemoveHudProgressBarPlayer(player, 0)
		player.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
		# Start the progress bars. First is the notfification text, second and third are keeping track of how many CPs are owned by each team
		GEUtil.InitHudProgressBarPlayer(player, 1, "", 0, 0, -1, .75, 80, 12, GEUtil.CColor(255,69,0, 100) )
		GEUtil.InitHudProgressBarPlayer( None, 2, "MI6:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.34, 0.04, 50, 15, GEUtil.CColor(0,150,255,255) )
		GEUtil.InitHudProgressBarPlayer( None, 3, "Janus:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.5, 0.04, 50, 15, GEUtil.CColor(255,0,0,255) )
		GEUtil.UpdateHudProgressBarPlayer(None, 2, float(self.upGetControls(GEGlobal.TEAM_MI6)))
		GEUtil.UpdateHudProgressBarPlayer(None, 3, float(self.upGetControls(GEGlobal.TEAM_JANUS)))
		# Next checks if number of players has changed significantly since last check. If so change number of tokens.
		if self.upIPlayers + 4 < GEMPGameRules.GetNumActivePlayers() or self.upIPlayers - 4 > GEMPGameRules.GetNumActivePlayers():
			self.upIPlayers = GEMPGameRules.GetNumActivePlayers()
			GEMPGameRules.GetTokenMgr().SetTokenSpawnLimit( "token_deathmatch" , self.upControlPointsNumber() )
		# Show pop-up help if first spawn
		if isFirstSpawn:
			GEUtil.ShowPopupHelp( player, "Uplink", "Work with your team to take control of as many Control Points as you can. Your team will get points based on the amount of time they control each Control Point.", "", 6 )
			GEUtil.ShowPopupHelp( player, "Control Points", "Control Points are represented by colored circles on your radar and a flag at the center of the Control Point. Touch the Control Point's flag to take control of it.", "", 6 )
			GEUtil.ShowPopupHelp( player, "Contesting", "The more players on your team you have on a Control Point the faster you'll take control of it. You cannot take control of a Control Point if a member of the other team is standing on it.", "", 6 )
			GEUtil.ShowPopupHelp( player, "Created by\nWNxEuphonic", "Plugin By: BadPlayer\nSpecial Thanks: E-S", "", 3 )

	def OnPlayerKilled(self, victim, killer, weapon):
		if not victim:
			return
		# Clear victim's hud bars, associated cp, scoreboard color
		GEUtil.ConfigHudProgressBarPlayer( victim, 1, "", GEUtil.CColor(255,69,0, 100) )
		GEUtil.RemoveHudProgressBarPlayer(victim, 0)
		self.pltracker.SetValue( victim, self.UP_ASSOCIATED_CP, False )
		victim.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
		if not killer:
			victim.IncrementScore( -1 )
			return
		if victim.GetIndex() == killer.GetIndex():
			killer.IncrementScore( -1 )
			return
		elif killer.GetTeamNumber() == victim.GetTeamNumber():
			killer.IncrementScore( -1 )
			return
		else:
			# Give extra point if either of both players are on Control Point
			cpk = self.pltracker.GetValue( killer, self.UP_ASSOCIATED_CP )
			cpv = self.pltracker.GetValue( victim, self.UP_ASSOCIATED_CP )
			if str(cpk) != "False" or str(cpv) != "False":
				GEUtil.EmitGameplayEvent( "up_cpkill", "%i" % killer.GetUserID() )
				killer.IncrementScore( 2 )
				return
			else:
				killer.IncrementScore( 1 )
				return

	def CanPlayerHaveWeapon(self, player, weapon):
		# Prevent players from picking up Control Points
		if not weapon.GetClassname().startswith( "token_" ):
			return True
		else:
			cp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if not cp:
				self.upNearestCP( player )
			return False
	
	def OnThink(self):
		ActiveCPs = self.upActiveCPs()

		for i in range(len(self.tokenslist)):
			actoken = self.tokenslist[i]
			owntok = self.TOKENowner[actoken]
			if str(ActiveCPs[actoken]) == "False":
				if not actoken in self.contestedlist:
					self.upHUDContested(actoken)
					self.contestedlist.append(actoken)
			elif actoken in self.contestedlist:
				self.contestedlist.remove(actoken)
				self.upHUDUnContested(actoken)
			if ActiveCPs[actoken] == 0 and str(ActiveCPs[actoken]) != "False":
				if self.MI6timer[actoken] > 0:
					self.MI6timer[actoken] -= 1
				if self.JANUStimer[actoken] > 0:
					self.JANUStimer[actoken] -= 1
			elif ActiveCPs[actoken] > 0 and owntok != GEGlobal.TEAM_MI6:
				self.MI6timer[actoken] += ActiveCPs[actoken]
				if self.JANUStimer[actoken] >= 3:
					self.JANUStimer[actoken] -= 3
				else: self.JANUStimer[actoken] = 0
			elif ActiveCPs[actoken] < 0 and owntok != GEGlobal.TEAM_JANUS:
				self.JANUStimer[actoken] += int(math.fabs(ActiveCPs[actoken]))
				if self.MI6timer[actoken] >= 3:
					self.MI6timer[actoken] -=3
				else: self.MI6timer[actoken] = 0
			timermax = self.upCaptureTimer
			if self.MI6timer[actoken] > timermax:
				self.upChangeCPOwner(actoken, GEGlobal.TEAM_MI6)
				self.MI6timer[actoken] = 0
				self.upCaptureAward(actoken, "N")
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^iMI6 ^xcaptured a ^wControl Point")
			if self.JANUStimer[actoken] > timermax:
				self.upChangeCPOwner(actoken, GEGlobal.TEAM_JANUS)
				self.JANUStimer[actoken] = 0
				self.upCaptureAward(actoken, "N")
				GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^rJanus ^xcaptured a ^wControl Point")
			if owntok:
				self.TOKENpoints[actoken] += 1
				if self.TOKENpoints[actoken] > self.upCPPointBreak:
					self.TOKENpoints[actoken] = 0
					GEMPGameRules.GetTeam(owntok).IncrementRoundScore( 1 )
	
	def OnTokenSpawned(self, token):
		# When a token is spawned, performs actions to set it up for interaction
		self.tokenslist.append( token )
		self.TOKENowner[token] = False
		self.MI6timer[token] = 0
		self.JANUStimer[token] = 0
		self.TOKENpoints[token] = 0
		GEMPGameRules.GetRadar().AddRadarContact( token, GEGlobal.RADAR_TYPE_TOKEN, True, "sprites/hud/radar/capture_point", self.upColorNeutral )
		GEUtil.EmitGameplayEvent( "up_plugin_spawn", str(token.GetIndex()), str(self.upCPRadius), str(self.upPWhite))
		GEUtil.InitHudProgressBarPlayer( None, 2, "MI6:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.34, 0.04, 50, 15, GEUtil.CColor(0,150,255,255) )
		GEUtil.InitHudProgressBarPlayer( None, 3, "Janus:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.5, 0.04, 50, 15, GEUtil.CColor(255,0,0,255) )
		
	def OnTokenRemoved(self, token):
		self.upClearCP(token)
	
	#- - - - - - - - - - - - - - - - - - - - -#
	#            UTILITY FUNCTIONS            #
	#- - - - - - - - - - - - - - - - - - - - -#
	
	def upNearestCP(self, player):
		# Finds the distance between the player and all of the tokens, then finds the closest one and associates the player with it.
		closestd = 99999
		closestcp = False
		for i in range(len(self.tokenslist)):
			distance = GEUtil.DistanceBetween( player, self.tokenslist[i] )
			if distance < closestd:
				closestd = distance
				closestcp = self.tokenslist[i]
		if closestcp:
			self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, closestcp )
			player.SetScoreBoardColor(self.upScoreWhite)
			if closestcp in self.contestedlist:
				GEUtil.InitHudProgressBarPlayer(player, 0, "Capturing", 1, float(self.upCaptureTimer), -1, .75, 80, 12, GEUtil.CColor(220,220,220,100))
			else:
				self.upHUDText(closestcp, 1)
				
	def upCPDistance(self, player, cp):
		# Gets distance between a player and 1 cp
		if not cp or not player:
			pass
		else:
			distance = GEUtil.DistanceBetween( player, cp )
			return distance

	def upHUDText(self, cp, state):
	#		1 "Capturing Control Point" or "You Own This Control Point"
	#		2 "The Control Point Is Contested"
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if playercp == cp:
				if state == 1:
					if player.GetTeamNumber() == self.TOKENowner[cp]:
						GEUtil.ConfigHudProgressBarPlayer( player, 1, self.upMOwned, GEUtil.CColor(220,220,220,240) )
					else:
						GEUtil.InitHudProgressBarPlayer(player, 0, "Capturing", 1, float(self.upCaptureTimer), -1, .75, 80, 12, GEUtil.CColor(220,220,220,240))
				if state == 2:
					GEUtil.ConfigHudProgressBarPlayer( player, 1, self.upMCapturing, self.upMContested )

	def upHUDContested(self, cp):
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if playercp == cp:
					GEUtil.ConfigHudProgressBarPlayer( player, 0, "Contested!", GEUtil.CColor(83,48,48,255) )

	def upHUDUnContested(self, cp):
		# Shows a contested bar for players associated with the cp
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if playercp == cp:
				GEUtil.ConfigHudProgressBarPlayer( player, 0, "Capturing", GEUtil.CColor(220,220,220,240) )
	
	def upHUDRemove(self, cp):
		# Removes the progress bar for capturing for all players associated with a cp
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if playercp == cp:
				GEUtil.RemoveHudProgressBarPlayer(player, 0)

	def upControlPointsNumber(self):
		# Returns the number of tokens to spawn based on the number of players.
		num = GEMPGameRules.GetNumActivePlayers()
		if num < 6:
			max = 3
		elif num < 11:
			max = 4
		elif num < 16:
			max = 5
		else:
			max = 6
		GEUtil.RemoveHudProgressBarPlayer(None, 2)
		GEUtil.RemoveHudProgressBarPlayer(None, 3)
		GEUtil.InitHudProgressBarPlayer( None, 2, "MI6:", GEGlobal.HUDPB_SHOWVALUE, max, 0.34, 0.04, 50, 15, GEUtil.CColor(0,150,255,255) )
		GEUtil.InitHudProgressBarPlayer( None, 3, "Janus:", GEGlobal.HUDPB_SHOWVALUE, max, 0.5, 0.04, 50, 15, GEUtil.CColor(255,0,0,255) )
		self.tokensmax = max
		return max
	
	def upClearCPs(self):
		# Removes all CPs from play
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, False )
			player.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
		for i in range(len(self.tokenslist)):
			GEUtil.EmitGameplayEvent( "up_plugin_kill", str(self.tokenslist[i].GetIndex()))
		self.TOKENowner = dict()
		self.MI6timer = dict()
		self.JANUStimer = dict()
		self.TOKENpoints = dict()
		self.tokenslist = []
		self.contestedlist = []
	
	def upClearCP(self, cp):
		# Removes a single CP from play
		if not cp: pass
		else:
			GEMPGameRules.GetRadar().DropRadarContact(cp)
			for i in range(32):
				if not GEUtil.IsValidPlayerIndex(i):
					continue
				player = GEUtil.GetMPPlayer(i)
				playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
				if playercp == cp:
					self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, False )
					player.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
					GEUtil.RemoveHudProgressBarPlayer(player, 0)
					GEUtil.ConfigHudProgressBarPlayer(player, 1, "", GEUtil.CColor(255,69,0, 100) )
			self.TOKENowner[cp] = False
			self.MI6timer[cp] = 0
			self.JANUStimer[cp] = 0
			self.TOKENpoints[cp] = 0
			if cp in self.tokenslist:
				self.tokenslist.remove(cp)
			GEUtil.EmitGameplayEvent( "up_plugin_kill", str(cp.GetIndex()) )
			GEUtil.InitHudProgressBarPlayer( None, 2, "MI6:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.34, 0.04, 50, 15, GEUtil.CColor(0,150,255,255) )
			GEUtil.InitHudProgressBarPlayer( None, 3, "Janus:", GEGlobal.HUDPB_SHOWVALUE, self.tokensmax, 0.5, 0.04, 50, 15, GEUtil.CColor(255,0,0,255) )
	
	def upActiveCPs(self):
		# The setup needed before OnThink is used, runs through each token and sees how many players from each team are associated with it
		# Janus returns a negative score, MI6 positive, False means a mix of both teams, 0 is no players
		ActiveCPs = dict()
		for i in range(len(self.tokenslist)):
			ActiveCPs[self.tokenslist[i]] = 0
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			cp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if self.upCPDistance(player, cp) > self.upCPRadius:
				self.pltracker.SetValue( player, self.UP_ASSOCIATED_CP, False )
				GEUtil.ConfigHudProgressBarPlayer(player, 1, "", GEUtil.CColor(255,69,0, 100) )
				GEUtil.RemoveHudProgressBarPlayer(player, 0)
				cp = False
				player.SetScoreBoardColor( GEGlobal.SB_COLOR_NORMAL )
			if not cp:
				continue
			# So in this next part, MI6 adds +1, JANUS -1. If two teams both have people on the same CP, it changes to False.
			elif player.GetTeamNumber() == GEGlobal.TEAM_MI6:
				GEUtil.UpdateHudProgressBarPlayer(player, 0, float( self.MI6timer[cp]))
				if str(ActiveCPs[cp]) == str(False):
					continue
				elif ActiveCPs[cp] < 0:
					ActiveCPs[cp] = False
				else: ActiveCPs[cp] += 1
			elif player.GetTeamNumber() == GEGlobal.TEAM_JANUS:
				GEUtil.UpdateHudProgressBarPlayer(player, 0, float( self.JANUStimer[cp] ))
				if str(ActiveCPs[cp]) == str(False):
					continue
				elif ActiveCPs[cp] > 0:
					ActiveCPs[cp] = False
				else: ActiveCPs[cp] -= 1
		return ActiveCPs
	
	def upChangeCPOwner(self, cp, team):
		# Updates a token to a new owner
		if not cp or not team:
			pass
		else:
			self.TOKENowner[cp] = team
			self.TOKENpoints[cp] = 0
			GEMPGameRules.GetRadar().DropRadarContact( cp )
			self.upHUDRemove(cp)
			self.upHUDText(cp, 1)
			if team == GEGlobal.TEAM_MI6:
				GEMPGameRules.GetRadar().AddRadarContact( cp, GEGlobal.RADAR_TYPE_TOKEN, True, "sprites/hud/radar/capture_point", self.upColorMI6 )
				GEUtil.EmitGameplayEvent( "up_plugin_update", str(cp.GetIndex()), str(self.upPBlue))
				GEUtil.EmitGameplayEvent( "up_capture_team", "%i" % GEGlobal.TEAM_MI6 )
				GEUtil.PlaySoundToTeam( GEGlobal.TEAM_JANUS, "GEGamePlay.Token_Drop_Enemy", False )
				GEUtil.PlaySoundToTeam( GEGlobal.TEAM_MI6, "GEGamePlay.Token_Grab", False )
			elif team == GEGlobal.TEAM_JANUS:
				GEMPGameRules.GetRadar().AddRadarContact( cp, GEGlobal.RADAR_TYPE_TOKEN, True, "sprites/hud/radar/capture_point", self.upColorJanus )
				GEUtil.EmitGameplayEvent( "up_plugin_update", str(cp.GetIndex()), str(self.upPRed))
				GEUtil.EmitGameplayEvent( "up_capture_team", "%i" % GEGlobal.TEAM_JANUS )
				GEUtil.PlaySoundToTeam( GEGlobal.TEAM_MI6, "GEGamePlay.Token_Drop_Enemy", False )
				GEUtil.PlaySoundToTeam( GEGlobal.TEAM_JANUS, "GEGamePlay.Token_Grab", False )
			GEUtil.UpdateHudProgressBarPlayer(None, 2, float(self.upGetControls(GEGlobal.TEAM_MI6)))
			GEUtil.UpdateHudProgressBarPlayer(None, 3, float(self.upGetControls(GEGlobal.TEAM_JANUS)))
			GEMPGameRules.GetTeam(team).IncrementRoundScore( 1 )
	
	def upCaptureAward(self, cp, type):
		# When a Control Point is captured, gives players associated with it points by running through all players and checking their associated cps
		for i in range(32):
			if not GEUtil.IsValidPlayerIndex(i):
				continue
			player = GEUtil.GetMPPlayer(i)
			playercp = self.pltracker.GetValue( player, self.UP_ASSOCIATED_CP )
			if playercp == cp:
				#GEUtil.PlaySoundToPlayer(player,"GEGamePlay.Token_Chime")
				if type == "N":
					player.IncrementScore( 2 )
					GEUtil.EmitGameplayEvent( "up_capture_neutral", "%i" % player.GetUserID() )
				else:
					player.IncrementScore( 3 )
					GEUtil.EmitGameplayEvent( "up_capture_steal", "%i" % player.GetUserID() )
	
	def upGetControls(self, team):
		# Gets the number of control points owned by the given team
		n = 0
		for i in range(len(self.tokenslist)):
			if self.TOKENowner[self.tokenslist[i]] == team:
				n += 1
		return n