from GamePlay import PYBaseGamePlay

import GEEntity, GEPlayer, GEUtil, GEWeapon, GEMPGameRules, GEGlobal

#Your weapons are INVINCIBLE! Alas, you are not...

class Rockets(PYBaseGamePlay):
	def __init__(self):
		super(Rockets, self).__init__()

	def GetPrintName(self):
		return "Rocket Jumping"
		
	def GetHelpString(self):
		return "Various settings to complement rocket jumping maps."
		
	def GetGameDescription(self):
		return "Rocket Jumping"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
                self.CreateCVar("rj_worlddamage", "1", "World Can Damage Players")
                self.CreateCVar("rj_selfdamage", "0", "Players Can Damage Themselves")
                self.CreateCVar("rj_playerdamage", "0", "Players Can Damage Eachother")
                self.CreateCVar("rj_tokenincentive", "0", "A token spawned in the end of the map concludes the match when picked up")
		self.LoadConfig()
		if int(GEUtil.GetCVarValue("rj_tokenincentive")) == 1:
                        tokenmgr = GEMPGameRules.GetTokenMgr()
                        tokenmgr.AddTokenType('token_deathmatch', 1, GEGlobal.SPAWN_TOKEN)
                        tokenmgr.SetTokenAllowSwitch('token_deathmatch', True)
                        tokenmgr.SetTokenRespawnDelay('token_deathmatch', 20 )
                        tokenmgr.SetCustomTokenSettings('token_deathmatch', "models/weapons/tokens/v_flagtoken.mdl", "models/weapons/tokens/w_flagtoken.mdl", "Flag" )
	
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()

	def OnPlayerSpawn(self, player, isFirstSpawn):
                player.SetArmor(int(GEGlobal.GE_MAX_ARMOR))

                if isFirstSpawn:
			GEUtil.ShowPopupHelp( player, "Rocket Jumping", "Rocket Jumping in GE:S is not so different from other games. However, while the concept is similar, the execution is not.                                                                                        Press H to continue", "", 30)
			GEUtil.ShowPopupHelp( player, "How To Rocket Jump", "The timing for rocket jumping is very important, but even more important is the method.  Crouch jumping should be avoided, as it severly reduces airtime.  It is also imperative to fire before jumping, not after.","", 30)
			GEUtil.ShowPopupHelp( player, "Advanced Techniques", "A rocket aimed at the ground slightly infront of a player will boost them higher than one aimed straight down.  Firing a rocket at the bottom part of a wall will allow a player to jump far without needing the higher ceiling required for more conventional jumps.", "", 30)
			GEUtil.ShowPopupHelp( player, "Air Strafing", "Air control is important, expecially in bigger jumps.  Airstrafing allows a rocket jumper to make sharp turns in midair.  To do this, release the foward movement key while in midair and hold the strafe key which corresponds with the direction you wish to move in.  Then, slowly turn in that direction.  When done right, this is a powerful tool, but it can be very hard to master!", "", 30)


	def ShouldDoCustomDamage(self, victim, info, health, armour):
                killer = GEPlayer.ToMPPlayer(info.GetAttacker())
                killerid = GEEntity.GetUniqueId(GEPlayer.ToMPPlayer(info.GetAttacker()))
                target = GEEntity.GetUniqueId(victim)
                if int(GEUtil.GetCVarValue("rj_worlddamage")) == 1:
                        if killer == None:
                                return health, armour
                if int(GEUtil.GetCVarValue("rj_selfdamage")) == 1:
                        if killerid == target:
                                return health, armour
                if int(GEUtil.GetCVarValue("rj_playerdamage")) == 1:
                        if killerid != target and killer != None:
                                return health, armour
                armour = 0
                health = 0        
		return health, armour

	def OnThink(self):
               	for i in range(32):
			if GEUtil.IsValidPlayerIndex(i):
                                player = GEUtil.GetMPPlayer(i)
                                if not player.IsDead():
                                        player.GiveNamedWeapon("weapon_rocket_launcher", 6)
                                if player.GetHealth() < GEGlobal.GE_MAX_HEALTH:
                                        player.SetHealth(player.GetHealth() + 10)
                                if player.GetHealth() > GEGlobal.GE_MAX_HEALTH:
                                        player.SetHealth(GEGlobal.GE_MAX_HEALTH)

        def OnTokenPicked(self, token, player):
                GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^i%s has completed the map!" % player.GetPlayerName() )
		player.SetScoreBoardColor( GEGlobal.SB_COLOR_WHITE )
		GEMPGameRules.EndMatch()

