from GamePlay import GEScenario
from GamePlay.Utils.GEPlayerTracker import GEPlayerTracker
import GEEntity, GEPlayer, GEUtil, GEMPGameRules, GEGlobal

USING_API = GEGlobal.API_VERSION_1_0_0

#Rocket Jumping V4   

class Rockets(GEScenario):

        Lastattack = "lastattack"
        Regentime = "RegenerationTime"
        FlagsReached = "flagsReached"
        
	def __init__(self):
            super(Rockets, self).__init__()
            
            self.pltracker = GEPlayerTracker( self )

	def Cleanup( self ):
		super( Rockets, self ).Cleanup()
		self.pltracker = None
		

	def GetPrintName(self):
		return "Rocket Jumping"
		
	def GetScenarioHelp( self, help_obj ):
		help_obj.SetDescription( "This is the help.  If you need the help you know where to find it. V4" )
		
	def GetGameDescription(self):
		return "Rocket Jumping"

	def GetTeamPlay(self):
		return GEGlobal.TEAMPLAY_TOGGLE
		
	def OnLoadGamePlay(self):
                self.CreateCVar("rj_worlddamage", "1", "World Can Damage Players")
                self.CreateCVar("rj_selfdamage", "0", "Players Can Damage Themselves")
                self.CreateCVar("rj_playerdamage", "0", "Players Can Damage Each other")
                self.CreateCVar("rj_regendelay", "1", "Delay in seconds before players can regenerate HP after taking damage")
                
	def OnRoundBegin(self):
		GEMPGameRules.ResetAllPlayersScores()

		GEMPGameRules.DisableWeaponSpawns()
		GEMPGameRules.DisableAmmoSpawns()

	def OnPlayerSpawn(self, player):
#                player.SetArmor(int(GEGlobal.GE_MAX_ARMOR))
                player.StripAllWeapons()
                player.SetDamageMultiplier( 1 )
                player.GiveNamedWeapon("weapon_rocket_launcher", 6)
                player.GiveNamedWeapon("weapon_knife", 0)
                self.pltracker.SetValue( player, self.Regentime, 0 )
                self.pltracker.SetValue( player, self.FlagsReached, 0 )

                if player.IsInitialSpawn():
                    GEUtil.PopupMessage( player, "Rocket Jumping", "Rocket Jumping in GE:S is not so different from other games. However, while the concept is similar, the execution is not.                                                                                        Press H to continue", "")
                    GEUtil.PopupMessage( player, "How To Rocket Jump", "The timing for rocket jumping is very important, but even more important is the method.  Crouch jumping should be avoided, as it severly reduces airtime.  It is also imperative to fire before jumping, not after.","")
                    GEUtil.PopupMessage( player, "Advanced Techniques", "A rocket aimed at the ground slightly infront of a player will boost them higher than one aimed straight down.  Firing a rocket at the bottom part of a wall will allow a player to jump far without needing the higher ceiling required for more conventional jumps.", "")
                                                                       
	def CalculateCustomDamage( self, victim, info, health, armour ):
                killer = GEPlayer.ToMPPlayer(info.GetAttacker())
                killerid = GEEntity.GetUniqueId(GEPlayer.ToMPPlayer(info.GetAttacker()))
                target = GEEntity.GetUniqueId(victim)
                damage = health + armour
                
                if int(GEUtil.GetCVarValue("rj_worlddamage")) == 1:
                        if killer == None:
                                if damage > 1000:
                                        victim.ForceRespawn()
                                        GEUtil.EmitGameplayEvent( "rj_pitfall", "%i" % victim.GetUserID())
                                else:
                                        health = 0
                                        
                                self.setregentime(victim)
                                return health, armour
                if int(GEUtil.GetCVarValue("rj_selfdamage")) == 1:
                        if killerid == target:
                                self.setregentime(victim)
                                return health, armour 
                                         
                if int(GEUtil.GetCVarValue("rj_playerdamage")) == 1:
                        if killerid != target and killer != None:                                
                                self.setregentime(victim)
                                return health, armour
                armour = 0
                health = 0        
                return health, armour

        def OnThink(self):
            for i in range(32):
                if GEPlayer.IsValidPlayerIndex(i):
                    player = GEPlayer.GetMPPlayer(i)
                    if not player.IsDead():
                        player.GiveNamedWeapon("weapon_rocket_launcher", 6)
                        self.regenerate(player)

        def CanPlayerHaveWeapon(self, player, weapon):
            if not weapon.GetClassname().startswith( "token_" ):
                return True
            else:
                if self.pltracker.GetValue( player, self.FlagsReached ) < 1:
                    GEUtil.ClientPrintAll(GEGlobal.HUD_PRINTTALK, "^i%s has completed the map!" % player.GetPlayerName() )
                    player.SetScoreBoardColor( GEGlobal.SB_COLOR_WHITE )
                    self.pltracker.SetValue( player, self.FlagsReached, 1 )
                    player.IncrementScore( 1 )
                return False

            
    
	# Custom Functions #

    # Is called every cycle; it checks to see if the player is damaged and if the regeneration delay has expired yet.
    
        def regenerate(self, player):
            if player.GetHealth() < GEGlobal.GE_MAX_HEALTH:
                    if self.pltracker.GetValue( player, self.Regentime ) < GEUtil.GetTime():
                        player.SetHealth(player.GetHealth() + 10)
                        if player.GetHealth() > GEGlobal.GE_MAX_HEALTH: 
                                player.SetHealth(GEGlobal.GE_MAX_HEALTH)
            return
                                
    # Is called whenever a player takes damage; it derives the time in which the player is allowed to start healing after being hurt.

        def setregentime(self, player):
                self.pltracker.SetValue( player, self.Regentime, GEUtil.GetTime() + int(GEUtil.GetCVarValue("rj_regendelay")) )
                return
